/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.bootstrap.BootstrapUtils;
import com.pmease.quickbuild.entitymanager.IdManager;
import com.pmease.quickbuild.equinoxadapter.EquinoxAdapter;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.MiscUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.io.XPP3Reader;
import org.hibernate.util.SerializationHelper;

public class FileUtils
extends org.apache.commons.io.FileUtils {
    public static void deleteFile(File file) {
        int maxTries = 10;
        int numTries = 1;
        while (!file.delete() && file.exists()) {
            if (numTries == maxTries) {
                throw new QuickbuildException("Failed to delete file '" + file.getAbsolutePath() + "'.");
            }
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++numTries;
        }
    }

    public static File createTempFile(String prefix, String suffix) {
        return BootstrapUtils.createTempFile((String)prefix, (String)suffix);
    }

    public static File createTempFile(String prefix) {
        return BootstrapUtils.createTempFile((String)prefix, (String)".tmp");
    }

    public static File createTempDir(String prefix) {
        File tempDir = new File(Bootstrap.getTempDir(), prefix + UUID.randomUUID().toString());
        if (!tempDir.mkdir()) {
            throw new QuickbuildException("Can not create temp directory.");
        }
        return tempDir;
    }

    public static File createTempDir() {
        return Files.createTempDir();
    }

    public static void cleanDir(File dir) {
        if (dir.exists()) {
            FileUtils.deleteDir(dir);
        }
        FileUtils.createDir(dir);
    }

    public static synchronized void createDir(File dir) {
        if (dir.exists()) {
            if (dir.isFile()) {
                throw new QuickbuildException("Unable to create directory since the path is already used by a file: " + dir.getAbsolutePath());
            }
        } else if (!dir.mkdirs() && !dir.exists()) {
            throw new QuickbuildException("Unable to create directory: " + dir);
        }
    }

    public static String readFileAsString(File file) {
        try {
            return org.apache.commons.io.FileUtils.readFileToString((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readFileAsString(File file, String encoding) {
        try {
            return org.apache.commons.io.FileUtils.readFileToString((File)file, (String)encoding);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readFileAsString(File file, String pattern, int range) {
        return FileUtils.readFileAsString(file, FileUtils.getDefaultEncoding(), pattern, range);
    }

    public static String readFileAsString(File file, String encoding, String pattern, int range) {
        String string;
        BufferedReader reader;
        block12: {
            String line;
            Pattern linePattern = Pattern.compile(pattern);
            HashSet<Integer> markedLines = new HashSet<Integer>();
            reader = null;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
            int position = 0;
            while ((line = reader.readLine()) != null) {
                if (line.length() < 1024 && linePattern.matcher(line).find()) {
                    for (int i = 0; i < range; ++i) {
                        markedLines.add(position - i);
                        markedLines.add(position + i);
                    }
                }
                ++position;
            }
            StringBuffer content = new StringBuffer();
            String abbreviation = "...\n...\n...\n";
            boolean markingBlock = false;
            reader.close();
            reader = null;
            boolean lineAppended = false;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
            position = 0;
            while ((line = reader.readLine()) != null) {
                if (markedLines.contains(position)) {
                    if (!markingBlock) {
                        content.append(abbreviation);
                    }
                    markingBlock = true;
                    content.append(StringEscapeUtils.escapeHtml((String)line));
                    lineAppended = true;
                    content.append("\n");
                } else {
                    markingBlock = false;
                }
                ++position;
            }
            content.append(abbreviation);
            if (!lineAppended) break block12;
            String string2 = content.toString();
            IOUtils.closeQuietly((Reader)reader);
            return string2;
        }
        try {
            string = "";
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }

    public static void writeFile(File file, String content) {
        try {
            org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeFile(File file, VersionedDocument dom) {
        FileUtils.writeFile(file, dom, false, true, true);
    }

    public static void writeFile(File file, VersionedDocument dom, boolean clearPasswords, boolean newlines, boolean indent) {
        if (clearPasswords) {
            for (Node node : dom.selectNodes("//*[@secret]")) {
                Element element = (Element)node;
                element.addAttribute("secret", "mask");
                element.setText("*****");
            }
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            OutputFormat format = new OutputFormat();
            format.setIndent(indent);
            format.setNewlines(newlines);
            format.setEncoding("UTF-8");
            XMLWriter writer = new XMLWriter((OutputStream)os, format);
            writer.write((Document)dom);
        }
        catch (Exception e) {
            try {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    public static VersionedDocument readFileAsDom(File file) {
        try {
            return new VersionedDocument(new XPP3Reader().read(FileUtils.readFileAsString(file, "UTF-8").toCharArray()));
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }

    public static void writeFile(File file, String content, String encoding) {
        try {
            org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)content, (String)encoding);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyDir(File srcDir, File destDir) {
        try {
            org.apache.commons.io.FileUtils.copyDirectory((File)srcDir, (File)destDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyFiles(File srcDir, String patterns, File destDir) {
        for (File file : FileUtils.listFiles(srcDir, patterns)) {
            String relativePath = FileUtils.getRelativePath(file.getAbsolutePath(), srcDir.getAbsolutePath());
            File destFile = new File(destDir, relativePath);
            if (file.isFile()) {
                FileUtils.createDir(destFile.getParentFile());
                FileUtils.copyFile(file, destFile);
                if (!file.canExecute()) continue;
                destFile.setExecutable(true);
                continue;
            }
            FileUtils.createDir(destFile);
        }
    }

    public static void copyFile(File srcFile, File destFile) {
        try {
            org.apache.commons.io.FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyFile(File srcFile, File destFile, boolean preserveFileDate) {
        try {
            org.apache.commons.io.FileUtils.copyFile((File)srcFile, (File)destFile, (boolean)preserveFileDate);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyFile(File srcFile, File destFile, boolean preserveFileDate, boolean preserveReadOnly) {
        try {
            org.apache.commons.io.FileUtils.copyFile((File)srcFile, (File)destFile, (boolean)preserveFileDate);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (preserveReadOnly && !srcFile.canWrite()) {
            destFile.setReadOnly();
        }
    }

    public static List<String> readFileAsLines(File file) {
        try {
            return org.apache.commons.io.FileUtils.readLines((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> readFileAsLines(File file, String encoding) {
        try {
            return org.apache.commons.io.FileUtils.readLines((File)file, (String)encoding);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeFile(File file, Collection<String> lines) {
        try {
            org.apache.commons.io.FileUtils.writeLines((File)file, lines);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeFile(File file, Collection<String> lines, String encoding) {
        try {
            org.apache.commons.io.FileUtils.writeLines((File)file, (String)encoding, lines);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeFile(File file, byte[] bytes) {
        try {
            org.apache.commons.io.FileUtils.writeByteArrayToFile((File)file, (byte[])bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeFile(File file, Serializable serializable) {
        FileUtils.writeFile(file, SerializationHelper.serialize(serializable));
    }

    public static void createFile(File file) {
        if (file.exists()) {
            FileUtils.deleteFile(file);
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] readFileAsBytes(File file) {
        byte[] byArray;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            byArray = IOUtils.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return byArray;
    }

    public static Object readFileAsObject(File file) {
        return SerializationHelper.deserialize(FileUtils.readFileAsBytes(file));
    }

    public static void deleteFiles(File baseDir, String filePatterns) {
        Delete deleteTask = new Delete();
        deleteTask.setProject(MiscUtils.createAntProject(Context.getLogger()));
        FileSet fileset = new FileSet();
        fileset.setProject(deleteTask.getProject());
        fileset.setDir(baseDir);
        if (SystemUtils.IS_OS_WINDOWS) {
            fileset.setCaseSensitive(false);
        }
        Pair<String[], String[]> includesExcludes = FileUtils.getIncludesExcludes(filePatterns);
        fileset.appendIncludes(includesExcludes.getFirst());
        fileset.appendExcludes(includesExcludes.getSecond());
        if (filePatterns.contains("defaultexcludes=no")) {
            fileset.setDefaultexcludes(false);
        }
        deleteTask.addFileset(fileset);
        deleteTask.execute();
    }

    public static Collection<File> listFiles(File baseDir, String filePatterns) {
        FileSet fileset = new FileSet();
        fileset.setProject(MiscUtils.createAntProject());
        fileset.setDir(baseDir);
        if (SystemUtils.IS_OS_WINDOWS) {
            fileset.setCaseSensitive(false);
        }
        Pair<String[], String[]> includesExcludes = FileUtils.getIncludesExcludes(filePatterns);
        fileset.appendIncludes(includesExcludes.getFirst());
        fileset.appendExcludes(includesExcludes.getSecond());
        if (filePatterns.contains("defaultexcludes=no")) {
            fileset.setDefaultexcludes(false);
        }
        ArrayList<File> files = new ArrayList<File>();
        DirectoryScanner scanner = fileset.getDirectoryScanner(fileset.getProject());
        for (String path : scanner.getIncludedDirectories()) {
            files.add(new File(baseDir, path));
        }
        for (String path : scanner.getIncludedFiles()) {
            files.add(new File(baseDir, path));
        }
        return files;
    }

    public static List<Pair<String, Boolean>> parsePathPatterns(String pathPatterns) {
        String[] splits = StringUtils.split((String)pathPatterns, (String)"\n,");
        ArrayList<Pair<String, Boolean>> parsed = new ArrayList<Pair<String, Boolean>>();
        for (String split : splits) {
            if ((split = split.trim()).length() == 0) continue;
            if (split.startsWith("+")) {
                parsed.add(new Pair<String, Boolean>(split.substring(1).trim(), true));
                continue;
            }
            if (split.startsWith("-")) {
                parsed.add(new Pair<String, Boolean>(split.substring(1).trim(), false));
                continue;
            }
            parsed.add(new Pair<String, Boolean>(split, true));
        }
        Collections.reverse(parsed);
        return parsed;
    }

    public static String getRelativePath(String longer, String shorter) {
        shorter = FilenameUtils.normalizeNoEndSeparator((String)shorter);
        if ((shorter = StringUtils.replace((String)shorter.trim(), (String)"\\", (String)"/")).length() != 0 && shorter.charAt(0) != '/') {
            shorter = "/" + shorter;
        }
        if (shorter.endsWith("/")) {
            shorter = StringUtils.stripEnd((String)shorter, (String)"/");
        }
        longer = FilenameUtils.normalizeNoEndSeparator((String)longer);
        if ((longer = StringUtils.replace((String)longer.trim(), (String)"\\", (String)"/")).length() != 0 && longer.charAt(0) != '/') {
            longer = "/" + longer;
        }
        if (longer.endsWith("/")) {
            longer = StringUtils.stripEnd((String)longer, (String)"/");
        }
        if (!longer.startsWith(shorter)) {
            return null;
        }
        String relativePath = longer.substring(shorter.length());
        if (relativePath.length() == 0) {
            return relativePath;
        }
        if (relativePath.charAt(0) != '/') {
            return null;
        }
        return relativePath;
    }

    public static void sortPaths(List<String> paths) {
        Collections.sort(paths, new Comparator<String>(){

            @Override
            public int compare(String path1, String path2) {
                return FileUtils.comparePath(path1, path2);
            }
        });
    }

    public static int comparePath(String path1, String path2) {
        String top2;
        if ((path1 = StringUtils.replace((String)StringUtils.stripEnd((String)path1, (String)"/\\"), (String)"\\", (String)"/")).equals(path2 = StringUtils.replace((String)StringUtils.stripEnd((String)path2, (String)"/\\"), (String)"\\", (String)"/"))) {
            return 0;
        }
        if (path1.startsWith(path2)) {
            return 1;
        }
        if (path2.startsWith(path1)) {
            return -1;
        }
        String top1 = StringUtils.substringBefore((String)path1, (String)"/");
        int result = top1.compareTo(top2 = StringUtils.substringBefore((String)path2, (String)"/"));
        if (result != 0) {
            return result;
        }
        return FileUtils.comparePath(StringUtils.substringAfter((String)path1, (String)"/"), StringUtils.substringAfter((String)path2, (String)"/"));
    }

    public static Pair<String[], String[]> getIncludesExcludes(String pathPatterns) {
        if (StringUtils.isNotBlank((String)pathPatterns)) {
            ArrayList<String> includes = new ArrayList<String>();
            ArrayList<String> excludes = new ArrayList<String>();
            for (Pair<String, Boolean> each : FileUtils.parsePathPatterns(pathPatterns)) {
                if (each.getSecond().booleanValue()) {
                    includes.add(each.getFirst());
                    continue;
                }
                excludes.add(each.getFirst());
            }
            return new Pair<String[], String[]>(includes.toArray(new String[includes.size()]), excludes.toArray(new String[excludes.size()]));
        }
        return new Pair<String[], String[]>(new String[0], new String[0]);
    }

    public static boolean matches(String path, String pathPattern) {
        String[] separators = new String[]{File.separator, File.separator, File.separator, File.separator, File.separator, File.separator};
        String normalizedPathPattern = StringUtils.replaceEach((String)pathPattern, (String[])new String[]{"///", "//", "/", "\\\\\\", "\\\\", "\\"}, (String[])separators);
        String normalizedPath = StringUtils.replaceEach((String)path, (String[])new String[]{"///", "//", "/", "\\\\\\", "\\\\", "\\"}, (String[])separators);
        return SelectorUtils.matchPath((String)normalizedPathPattern, (String)normalizedPath);
    }

    public static boolean matches(String path, List<Pair<String, Boolean>> parsedPathPatterns) {
        boolean hasIncludePatterns = false;
        for (Pair<String, Boolean> each : parsedPathPatterns) {
            boolean matched = FileUtils.matches(path, each.getFirst());
            if (matched) {
                return each.getSecond();
            }
            if (!each.getSecond().booleanValue()) continue;
            hasIncludePatterns = true;
        }
        return !hasIncludePatterns;
    }

    public static File findChild(File dir, String name) {
        File file = new File(dir, name);
        if (file.exists()) {
            return file;
        }
        for (File child : dir.listFiles()) {
            if (!child.isDirectory() || (file = FileUtils.findChild(child, name)) == null) continue;
            return file;
        }
        return null;
    }

    public static String getDefaultEncoding() {
        return new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();
    }

    public static void copyUrlToFile(URL url, File file) {
        try {
            org.apache.commons.io.FileUtils.copyURLToFile((URL)url, (File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void pruneDir(File dir, final String name) {
        for (File child : dir.listFiles()) {
            if (child.getName().equals(name) || !child.isDirectory()) continue;
            FileUtils.pruneDir(child, name);
        }
        if (dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals(name);
            }
        }).length == 0) {
            FileUtils.deleteDir(dir);
        }
    }

    public static void sortFiles(List<File> files) {
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                if (file1.isDirectory()) {
                    if (file2.isDirectory()) {
                        return file1.getName().compareTo(file2.getName());
                    }
                    return -1;
                }
                if (file2.isDirectory()) {
                    return 1;
                }
                return file1.getName().compareTo(file2.getName());
            }
        });
    }

    public static void zip(File dir, File file) {
        BootstrapUtils.zip((File)dir, (File)file);
    }

    public static void unzip(File file, File dir) {
        BootstrapUtils.unzip((File)file, (File)dir);
    }

    public static Properties loadProps(File file) {
        return BootstrapUtils.loadProps((File)file);
    }

    public static void saveProps(File file, Properties props) {
        BootstrapUtils.saveProps((File)file, (Properties)props);
    }

    public static void saveProps(File file, Properties props, String comment) {
        BootstrapUtils.saveProps((File)file, (Properties)props, (String)comment);
    }

    public static File resolvePath(File baseDir, String path) {
        if (path != null) {
            File file = new File(path);
            if (file.isAbsolute()) {
                return file;
            }
            return new File(baseDir, path);
        }
        return baseDir;
    }

    public static File normalize(File file) {
        return new File(FilenameUtils.normalizeNoEndSeparator((String)file.getAbsolutePath()));
    }

    public static String normalize(String path) {
        return FilenameUtils.normalizeNoEndSeparator((String)path);
    }

    public static void deleteDir(File dir) {
        if (!dir.exists()) {
            return;
        }
        File[] children = dir.listFiles();
        if (children == null) {
            Context.getLogger().warn("Can not list directory: " + dir.getAbsolutePath());
            FileUtils.deleteFile(dir);
            return;
        }
        for (File child : children) {
            if (child.isDirectory()) {
                if (child.delete() || !child.exists()) continue;
                FileUtils.deleteDir(child);
                continue;
            }
            FileUtils.deleteFile(child);
        }
        FileUtils.deleteFile(dir);
    }

    public static boolean isFilePattern(String path) {
        return path.indexOf(42) != -1 || path.indexOf(63) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tar(File baseDir, Collection<File> files, boolean compress, OutputStream os) {
        TarArchiveOutputStream tos = null;
        try {
            byte[] data = new byte[65536];
            tos = compress ? new TarArchiveOutputStream((OutputStream)new GZIPOutputStream((OutputStream)new BufferedOutputStream(os, 65536), 65536)) : new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(os, 65536));
            tos.setLongFileMode(2);
            tos.setBigNumberMode(1);
            for (File file : files) {
                String basePath = FileUtils.getRelativePath(file.getAbsolutePath(), baseDir.getAbsolutePath());
                Preconditions.checkNotNull((Object)basePath);
                if (basePath.length() == 0) continue;
                basePath = basePath.substring(1);
                if (!file.isFile() && !basePath.endsWith("/")) {
                    basePath = basePath + "/";
                }
                FileInputStream is = null;
                try {
                    TarArchiveEntry entry = new TarArchiveEntry(basePath);
                    if (file.isFile()) {
                        entry.setSize(file.length());
                        if (file.canExecute()) {
                            entry.setMode(entry.getMode() | 0x40);
                        }
                        entry.setModTime(file.lastModified());
                    }
                    tos.putArchiveEntry((ArchiveEntry)entry);
                    if (file.isFile()) {
                        int count;
                        is = new FileInputStream(file);
                        while ((count = ((InputStream)is).read(data)) != -1) {
                            tos.write(data, 0, count);
                        }
                    }
                    tos.closeArchiveEntry();
                }
                finally {
                    IOUtils.closeQuietly(is);
                }
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(tos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)tos);
    }

    public static void tar(File baseDir, String filePatterns, boolean compress, OutputStream os) {
        Collection<File> files = FileUtils.listFiles(baseDir, filePatterns);
        FileUtils.tar(baseDir, files, compress, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void untar(InputStream is, boolean compressed, File destDir) {
        TarArchiveInputStream tis = null;
        try {
            TarArchiveEntry entry;
            byte[] data = new byte[65536];
            tis = compressed ? new TarArchiveInputStream((InputStream)new GZIPInputStream((InputStream)new BufferedInputStream(is, 65536), 65536)) : new TarArchiveInputStream((InputStream)new BufferedInputStream(is, 65536));
            while ((entry = tis.getNextTarEntry()) != null) {
                if (!entry.getName().endsWith("/")) {
                    BufferedOutputStream bos;
                    File destFile;
                    block10: {
                        destFile = new File(destDir, entry.getName());
                        File parentFile = destFile.getParentFile();
                        FileUtils.createDir(parentFile);
                        if (destFile.exists()) {
                            FileUtils.deleteFile(destFile);
                        }
                        bos = null;
                        try {
                            int count;
                            bos = new BufferedOutputStream(new FileOutputStream(destFile), 65536);
                            while ((count = tis.read(data)) != -1) {
                                ((OutputStream)bos).write(data, 0, count);
                            }
                            if ((entry.getMode() & 0x40) == 0) break block10;
                            destFile.setExecutable(true);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(bos);
                            destFile.setLastModified(entry.getModTime().getTime());
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((OutputStream)bos);
                    destFile.setLastModified(entry.getModTime().getTime());
                    continue;
                }
                FileUtils.createDir(new File(destDir, entry.getName()));
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(tis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)tis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File baseDir, String filePatterns, boolean compress, OutputStream os) {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new BufferedOutputStream(os, 65536));
            if (compress) {
                zos.setLevel(-1);
            } else {
                zos.setLevel(0);
            }
            byte[] buffer = new byte[65536];
            for (File file : FileUtils.listFiles(baseDir, filePatterns)) {
                String basePath;
                if (file.isFile()) {
                    basePath = FileUtils.getRelativePath(file.getAbsolutePath(), baseDir.getAbsolutePath());
                    Preconditions.checkNotNull((Object)basePath);
                    basePath = basePath.substring(1);
                    FileInputStream is = null;
                    try {
                        int len;
                        ZipEntry entry = new ZipEntry(basePath);
                        is = new FileInputStream(file);
                        entry.setSize(file.length());
                        zos.putNextEntry(entry);
                        while ((len = ((InputStream)is).read(buffer)) > 0) {
                            zos.write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    continue;
                }
                basePath = FileUtils.getRelativePath(file.getAbsolutePath(), baseDir.getAbsolutePath());
                Preconditions.checkNotNull((Object)basePath);
                if (basePath.length() == 0) continue;
                basePath = basePath.substring(1);
                ZipEntry entry = new ZipEntry(basePath + "/");
                zos.putNextEntry(entry);
            }
        }
        catch (Exception e) {
            try {
                throw BootstrapUtils.wrapAsUnchecked((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)zos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(InputStream is, File destDir) {
        ZipInputStream zis = null;
        byte[] buffer = new byte[65536];
        try {
            ZipEntry entry;
            zis = new ZipInputStream(new BufferedInputStream(is, 65536));
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.getName().endsWith("/")) {
                    File destFile = new File(destDir, entry.getName());
                    File parentFile = destFile.getParentFile();
                    FileUtils.createDir(parentFile);
                    if (destFile.exists()) {
                        FileUtils.deleteFile(destFile);
                    }
                    BufferedOutputStream bos = null;
                    try {
                        int count;
                        bos = new BufferedOutputStream(new FileOutputStream(destFile), 65536);
                        while ((count = zis.read(buffer)) != -1) {
                            ((OutputStream)bos).write(buffer, 0, count);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(bos);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)bos);
                    continue;
                }
                File dirToCreate = new File(destDir, StringUtils.stripEnd((String)entry.getName(), (String)"/"));
                FileUtils.createDir(dirToCreate);
            }
        }
        catch (Exception e) {
            try {
                throw BootstrapUtils.wrapAsUnchecked((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)zis);
    }

    public static void touchFile(File file) {
        try {
            FileUtils.touch((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean containsFileWithSuffix(File dir, String suffix) {
        File[] children = dir.listFiles();
        ArrayList<File> dirs = new ArrayList<File>();
        for (File each : children) {
            if (each.isFile()) {
                if (!each.getName().toLowerCase().endsWith(suffix.toLowerCase())) continue;
                return true;
            }
            dirs.add(each);
        }
        for (File each : dirs) {
            if (!FileUtils.containsFileWithSuffix(each, suffix)) continue;
            return true;
        }
        return false;
    }

    public static Long assignIdFor(File file) {
        String canonicalPath;
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String installPath = Bootstrap.installDir.getAbsolutePath();
        String relativePath = FileUtils.getRelativePath(canonicalPath, installPath);
        IdManager idManager = Quickbuild.getInstance(IdManager.class);
        if (relativePath != null) {
            return idManager.getId(String.valueOf(Bootstrap.getPort()) + ":" + relativePath);
        }
        return idManager.getId(canonicalPath);
    }

    public static String byteCountToDisplaySize(long size) {
        String displaySize = size / 0x40000000L > 0L ? String.format("%.2f", (double)size * 1.0 / 1.073741824E9) + " GB" : (size / 0x100000L > 0L ? String.format("%.2f", (double)size * 1.0 / 1048576.0) + " MB" : (size / 1024L > 0L ? String.format("%.2f", (double)size * 1.0 / 1024.0) + " KB" : String.valueOf(size) + " bytes"));
        return displaySize;
    }

    public static File locateLib(Class<?> locator, String libName) {
        File loadedFrom = ClassUtils.getClassFile(locator);
        File baseDir = loadedFrom.isDirectory() ? loadedFrom : EquinoxAdapter.getLibCacheDir();
        return new File(new File(baseDir, locator.getPackage().getName().replace(".", "/")), libName);
    }
}

