/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.bootstrap.BootstrapUtils;
import com.pmease.quickbuild.util.EasyMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ExceptionUtils {
    private static final int MAX_MESSAGE_LENGTH = 1000;

    public static <T extends Throwable> T extractException(Throwable throwable, Class<T> exceptionClass) {
        return (T)BootstrapUtils.extractException((Throwable)throwable, exceptionClass);
    }

    public static QuickbuildException extractQuickbuildException(Throwable throwable) {
        return ExceptionUtils.extractException(throwable, QuickbuildException.class);
    }

    public static String extractImportantMessage(Throwable throwable) {
        QuickbuildException quickbuildException = ExceptionUtils.extractException(throwable, QuickbuildException.class);
        if (quickbuildException != null) {
            return StringUtils.abbreviate((String)quickbuildException.getMessage(), (int)1000);
        }
        String message = throwable.getMessage();
        HashSet<Throwable> examinedCauses = new HashSet<Throwable>();
        examinedCauses.add(throwable);
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            if (StringUtils.isNotBlank((String)cause.getMessage())) {
                message = StringUtils.isNotBlank((String)message) ? message + "\ncaused by: " + cause.getMessage() : cause.getMessage();
            }
            examinedCauses.add(cause);
            if (examinedCauses.contains(cause.getCause())) break;
        }
        if (StringUtils.isBlank((String)message)) {
            return throwable.getClass().getSimpleName();
        }
        return StringUtils.abbreviate((String)message, (int)1000);
    }

    public static String buildMessage(String cause, Object ... factors) {
        return ExceptionUtils.buildMessage(cause, EasyMap.createOrdered(factors));
    }

    public static String buildMessage(String cause, Map factors) {
        String message = cause;
        message = message + " (";
        ArrayList<String> factorMessages = new ArrayList<String>();
        for (Map.Entry entry : factors.entrySet()) {
            factorMessages.add(entry.getKey().toString() + ":" + entry.getValue());
        }
        message = message + StringUtils.join(factorMessages.iterator(), (String)", ");
        message = message + ")";
        return message;
    }

    public static RuntimeException wrapAsUnchecked(Throwable throwable) {
        return BootstrapUtils.wrapAsUnchecked((Throwable)throwable);
    }

    public static RuntimeException wrapException(String message, Throwable throwable) {
        if (ExceptionUtils.extractQuickbuildException(throwable) != null) {
            throw new RuntimeException(message, throwable);
        }
        throw new QuickbuildException(message, throwable);
    }
}

