/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.pmease.quickbuild.util.Dependency;
import com.pmease.quickbuild.util.DependencyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DependencyHelper {
    public static <T extends Dependency> boolean hasTransitiveDependency(Map<String, T> dependencyContext, T dependent, T dependency) {
        Preconditions.checkArgument((!dependent.getId().equals(dependency.getId()) ? 1 : 0) != 0, (Object)"Dependent and dependency object should not be the same.");
        return DependencyHelper.hasTransitiveDependency(dependencyContext, dependent, dependency, (Set<String>)ImmutableSet.of((Object)dependent.getId()));
    }

    private static <T extends Dependency> boolean hasTransitiveDependency(Map<String, T> dependencyContext, T dependent, T dependency, Set<String> visited) {
        for (String dependencyId : dependent.getDependencyIds()) {
            if (dependencyId.equals(dependency.getId())) {
                return true;
            }
            if (visited.contains(dependencyId)) {
                throw new DependencyException("Circular dependency found: " + visited);
            }
            dependent = (Dependency)dependencyContext.get(dependencyId);
            if (dependent == null) {
                throw new DependencyException("Can not find dependency '" + dependencyId + "'.");
            }
            visited = new HashSet<String>(visited);
            visited.add(dependencyId);
            if (!DependencyHelper.hasTransitiveDependency(dependencyContext, dependent, dependency, visited)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Dependency> Set<T> getDependents(Map<String, T> dependencyContext, T dependency) {
        HashSet<Dependency> dependents = new HashSet<Dependency>();
        for (Dependency each : dependencyContext.values()) {
            if (!each.getDependencyIds().contains(dependency.getId())) continue;
            dependents.add(each);
        }
        return dependents;
    }

    public static <T extends Dependency> List<T> sortDependencies(Map<String, T> dependencyContext) {
        ArrayList<Dependency> sorted = new ArrayList<Dependency>();
        HashMap<String, HashSet<String>> dependencyIds = new HashMap<String, HashSet<String>>();
        for (Map.Entry<String, T> entry : dependencyContext.entrySet()) {
            dependencyIds.put(entry.getKey(), new HashSet<String>(((Dependency)entry.getValue()).getDependencyIds()));
        }
        while (!dependencyIds.isEmpty()) {
            HashSet<String> leafs = new HashSet<String>();
            for (String key : dependencyIds.keySet()) {
                if (!((Collection)dependencyIds.get(key)).isEmpty()) continue;
                leafs.add(key);
                Dependency dependency = (Dependency)dependencyContext.get(key);
                Preconditions.checkNotNull((Object)dependency);
                sorted.add(dependency);
            }
            if (leafs.isEmpty()) {
                HashSet<String> unprocessed = new HashSet<String>();
                for (String id : dependencyIds.keySet()) {
                    unprocessed.add(id);
                }
                throw new DependencyException("Unable to process dependencies: " + unprocessed + ". This is either because circular exists in these dependencies, or because " + "some of these dependencies depends on non-existent dependencies.");
            }
            for (String key : leafs) {
                dependencyIds.remove(key);
            }
            for (Collection value : dependencyIds.values()) {
                value.removeAll(leafs);
            }
        }
        return sorted;
    }
}

