/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.model.Setting;
import com.pmease.quickbuild.persistence.UnsupportedAgentOperationException;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.HibernateUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.hibernate.util.SerializationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUtils {
    private static final Logger logger = LoggerFactory.getLogger(DbUtils.class);
    private static String dataVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDbRunning() {
        Connection conn = null;
        try {
            conn = DbUtils.getConnection();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            DbUtils.closeQuietly(conn);
        }
    }

    public static boolean isMySQL() {
        Properties hibernateProps = HibernateUtils.loadProps();
        return hibernateProps.getProperty("hibernate.dialect").toLowerCase().contains("mysql");
    }

    public static boolean isPostgreSQL() {
        Properties hibernateProps = HibernateUtils.loadProps();
        return hibernateProps.getProperty("hibernate.dialect").toLowerCase().contains("postgresql");
    }

    public static boolean isOracle() {
        Properties hibernateProps = HibernateUtils.loadProps();
        return hibernateProps.getProperty("hibernate.dialect").toLowerCase().contains("oracle");
    }

    public static boolean isSQLServer() {
        Properties hibernateProps = HibernateUtils.loadProps();
        return hibernateProps.getProperty("hibernate.dialect").toLowerCase().contains("sqlserver");
    }

    public static boolean isH2() {
        Properties hibernateProps = HibernateUtils.loadProps();
        return hibernateProps.getProperty("hibernate.dialect").toLowerCase().contains("h2");
    }

    public static boolean isDB2() {
        Properties hibernateProps = HibernateUtils.loadProps();
        return hibernateProps.getProperty("hibernate.dialect").toLowerCase().contains("db2");
    }

    public static void closeQuietly(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(ResultSet resultset) {
        if (resultset != null) {
            try {
                resultset.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static Connection getConnection() {
        if (Bootstrap.isAgent()) {
            throw new UnsupportedAgentOperationException();
        }
        Properties props = HibernateUtils.loadProps();
        try {
            Class.forName(props.getProperty("hibernate.connection.driver_class"));
            Connection conn = DriverManager.getConnection(props.getProperty("hibernate.connection.url"), props.getProperty("hibernate.connection.username"), props.getProperty("hibernate.connection.password"));
            return conn;
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }

    public static void execute(List<String> sqls) {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DbUtils.getConnection();
            stmt = conn.createStatement();
            for (String sql : sqls) {
                logger.debug("Executing sql: " + sql);
                stmt.execute(sql);
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(stmt);
                DbUtils.closeQuietly(conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(stmt);
        DbUtils.closeQuietly(conn);
    }

    public static String getDataVersion() {
        if (dataVersion == null) {
            ResultSet resultset;
            Statement stmt;
            Connection conn;
            block10: {
                conn = null;
                stmt = null;
                resultset = null;
                conn = DbUtils.getConnection();
                conn.setAutoCommit(false);
                resultset = conn.getMetaData().getTables(null, null, DbUtils.isPostgreSQL() ? "qb_setting" : "QB_SETTING", null);
                if (resultset.next()) break block10;
                String string = null;
                DbUtils.closeQuietly(resultset);
                DbUtils.closeQuietly(stmt);
                DbUtils.closeQuietly(conn);
                return string;
            }
            try {
                try {
                    logger.info("QuickBuild version table found. Catalog: {}, Schema: {}, Name: {}, Type: {}", new Object[]{resultset.getString("TABLE_CAT"), resultset.getString("TABLE_SCHEM"), resultset.getString("TABLE_NAME"), resultset.getString("TABLE_TYPE")});
                }
                catch (Exception e) {
                    // empty catch block
                }
                resultset.close();
                stmt = conn.createStatement();
                resultset = stmt.executeQuery("select QB_OBJECT from QB_SETTING where QB_ID=" + Setting.DATA_VERSION_ID);
                if (!resultset.next()) {
                    throw new QuickbuildException("No data version found in database.");
                }
                dataVersion = SerializationHelper.deserialize(resultset.getBlob(1).getBinaryStream()).toString();
            }
            catch (Throwable e) {
                block11: {
                    String string;
                    try {
                        if (e.getMessage() == null || !e.getMessage().contains("ORA-00942")) break block11;
                        string = null;
                    }
                    catch (Throwable throwable) {
                        DbUtils.closeQuietly(resultset);
                        DbUtils.closeQuietly(stmt);
                        DbUtils.closeQuietly(conn);
                        throw throwable;
                    }
                    DbUtils.closeQuietly(resultset);
                    DbUtils.closeQuietly(stmt);
                    DbUtils.closeQuietly(conn);
                    return string;
                }
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
            DbUtils.closeQuietly(resultset);
            DbUtils.closeQuietly(stmt);
            DbUtils.closeQuietly(conn);
        }
        return dataVersion;
    }
}

