/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.pmease.quickbuild.Context;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.ocpsoft.prettytime.PrettyTime;

public class DateUtils
extends org.apache.commons.lang.time.DateUtils {
    public static final String AGE = "age";
    static PeriodFormatter shortWordFormatter = new PeriodFormatterBuilder().appendDays().appendSuffix("d").appendSeparator(", ").appendHours().appendSuffix("h").appendSeparator(":").appendMinutes().appendSuffix("m").appendSeparator(":").appendSeconds().appendSuffix("s").toFormatter();

    public static String formatAge(Date date) {
        return new PrettyTime().format(date);
    }

    public static String formatDate(Date date) {
        return DateUtils.formatDate(date, "yyyy-MM-dd");
    }

    public static String formatDateTime(Date date) {
        return DateUtils.formatDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String formatDate(Date date, String pattern) {
        return DateTimeFormat.forPattern((String)pattern).withZone(DateTimeZone.forTimeZone((TimeZone)Context.getTimeZone())).print((ReadableInstant)new DateTime((Object)date));
    }

    public static String formatDuration(long durationMillis) {
        if (durationMillis < 1000L) {
            return durationMillis + " ms";
        }
        return DurationFormatUtils.formatDurationWords((long)durationMillis, (boolean)true, (boolean)true);
    }

    public static String formatDurationShortWords(long durationMills) {
        if (durationMills < 1000L) {
            return durationMills + " ms";
        }
        Duration duration = new Duration(durationMills);
        return shortWordFormatter.print((ReadablePeriod)duration.toPeriod(PeriodType.yearMonthDayTime(), (Chronology)ISOChronology.getInstanceUTC()));
    }
}

