/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.validation.ErrorContext;
import com.pmease.quickbuild.validation.Validatable;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Months;
import org.joda.time.MutableDateTime;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.Weeks;

public class DateRange
implements Serializable,
Validatable {
    private static final long serialVersionUID = 1L;
    private static final String DATE_FORMAT_PATTERN = "MMMMM dd, yyyy";
    private Date beginDate;
    private Date endDate;

    public static DateRange weekOfDay(Date day) {
        MutableDateTime monday = new MutableDateTime((Object)day);
        MutableDateTime sunday = monday.copy();
        monday.setDayOfWeek(1);
        sunday.setDayOfWeek(7);
        return new DateRange(monday.toDate(), sunday.toDate());
    }

    public static DateRange monthOfDay(Date day) {
        MutableDateTime first = new MutableDateTime((Object)day);
        MutableDateTime last = first.copy();
        first.setDayOfMonth(first.dayOfMonth().getMinimumValue());
        last.setDayOfMonth(last.dayOfMonth().getMaximumValue());
        return new DateRange(first.toDate(), last.toDate());
    }

    public DateRange() {
        this.endDate = new Date();
        this.beginDate = DateUtils.addMonths((Date)this.endDate, (int)-1);
    }

    public DateRange(Date beginDate, Date endDate) {
        this.beginDate = beginDate;
        this.endDate = endDate;
    }

    public DateRange(long begin, long end) {
        this(new Date(begin), new Date(end));
    }

    public void truncateToDay() {
        this.beginDate = this.beginOfDay(this.beginDate);
        this.endDate = this.endOfDay(this.endDate);
    }

    public boolean contains(Date date) {
        return date.compareTo(this.beginOfDay(this.beginDate)) >= 0 && date.compareTo(this.endOfDay(this.endDate)) < 0;
    }

    public boolean contains(Date date, int field) {
        Date b = DateUtils.truncate((Date)this.beginDate, (int)field);
        Date e = DateUtils.truncate((Date)this.endDate, (int)field);
        Date d = DateUtils.truncate((Date)date, (int)field);
        return d.compareTo(b) >= 0 && d.compareTo(e) <= 0;
    }

    private Date beginOfDay(Date date) {
        return DateUtils.truncate((Date)date, (int)5);
    }

    private Date endOfDay(Date date) {
        Date d = DateUtils.truncate((Date)date, (int)5);
        return DateUtils.addDays((Date)d, (int)1);
    }

    @Editable
    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    @Editable
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isValid() {
        return this.beginDate.compareTo(this.endDate) <= 0;
    }

    public int days() {
        Period period = new Period((ReadablePartial)LocalDate.fromDateFields((Date)this.beginDate), (ReadablePartial)LocalDate.fromDateFields((Date)this.endDate), PeriodType.days());
        return period.getDays();
    }

    public int weeks() {
        MutableDateTime monday = new MutableDateTime((Object)this.beginDate);
        monday.setDayOfWeek(1);
        MutableDateTime sunday = new MutableDateTime((Object)this.endDate);
        sunday.setDayOfWeek(7);
        return Weeks.weeksBetween((ReadableInstant)monday, (ReadableInstant)sunday).getWeeks();
    }

    public int months() {
        MutableDateTime start = new MutableDateTime((Object)this.beginDate);
        start.setDayOfMonth(start.dayOfMonth().getMinimumValue());
        MutableDateTime end = new MutableDateTime((Object)this.endDate);
        end.setDayOfMonth(end.dayOfMonth().getMaximumValue());
        return Months.monthsBetween((ReadableInstant)start, (ReadableInstant)end).getMonths();
    }

    public static void main(String[] args) {
        DateTime start = new DateTime(2010, 2, 13, 14, 20, 30, 0);
        DateTime end = new DateTime(2010, 2, 13, 12, 18, 30, 0);
        DateRange range = new DateRange(start.toDate(), end.toDate());
        System.out.println("Days: " + range.days());
        System.out.println("Weeks: " + range.weeks());
        System.out.println("Months: " + range.months());
        System.out.println("WeeK of day: " + DateRange.weekOfDay(start.toDate()));
        System.out.println("Month of day: " + DateRange.monthOfDay(start.toDate()));
    }

    public String toShortString() {
        return DateUtils.formatDate(this.beginDate, "MMM d") + " - " + DateUtils.formatDate(this.endDate, "MMM d");
    }

    public String format(String pattern) {
        if (DateUtils.isSameDay((Date)this.beginDate, (Date)this.endDate)) {
            return DateUtils.formatDate(this.beginDate, pattern);
        }
        return DateUtils.formatDate(this.beginDate, pattern) + " - " + DateUtils.formatDate(this.endDate, pattern);
    }

    public String toString() {
        if (DateUtils.isSameDay((Date)this.beginDate, (Date)this.endDate)) {
            return DateUtils.formatDate(this.beginDate, "EEEEE, MMMMM dd, yyyy");
        }
        return DateUtils.formatDate(this.beginDate, DATE_FORMAT_PATTERN) + " - " + DateUtils.formatDate(this.endDate, DATE_FORMAT_PATTERN);
    }

    @Override
    public void validate(Set<String> properties, ErrorContext errorContext) {
        if (this.beginDate == null || this.endDate == null) {
            errorContext.setError("Begin date or end date shouldn't be empty.");
            return;
        }
        if (!this.isValid()) {
            errorContext.setError("Begin date shouldn't be after end date.");
        }
        if (this.endDate.after(new Date())) {
            errorContext.setError("End date shouldn't be after today.");
        }
    }
}

