/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.google.common.base.Preconditions;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.util.proxy.ProxyFactory;
import net.sf.cglib.proxy.Enhancer;

public class ClassUtils
extends org.apache.commons.lang.ClassUtils {
    public static Method getMethodIfAvailable(Class<?> clazz, String methodName, Class<?> ... params) {
        Class<?> current = clazz;
        while (true) {
            try {
                return current.getDeclaredMethod(methodName, params);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                if (current != Object.class) {
                    current = current.getSuperclass();
                    continue;
                }
                return null;
            }
            break;
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        Method m = ClassUtils.getMethodIfAvailable(clazz, methodName, params);
        if (m == null) {
            throw new QuickbuildException("Can not find method named '" + methodName + "' in class hierarchy of '" + clazz.getName() + "'.");
        }
        return m;
    }

    public static boolean hasMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        Class<?> current = clazz;
        while (true) {
            try {
                current.getDeclaredMethod(methodName, params);
                return true;
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                if (current != Object.class) {
                    current = current.getSuperclass();
                    continue;
                }
                return false;
            }
            break;
        }
    }

    public static boolean isSystemType(Class<?> type) {
        return type.getName().startsWith("java") || type.getName().startsWith("javax") || type.isArray() || type.isPrimitive() || type.isEnum();
    }

    public static Class<?> unproxy(Class<?> clazz) {
        Class<?> superClass = clazz;
        while (Enhancer.isEnhanced(superClass) || ProxyFactory.isProxyClass(superClass)) {
            superClass = clazz.getSuperclass();
        }
        return superClass;
    }

    public static Class<?> getCollectionElementType(Type type) {
        Type elementType;
        Class rawClazz;
        ParameterizedType parameterizedType;
        Type rawType;
        if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class && Collection.class.isAssignableFrom(rawClazz = (Class)rawType) && (elementType = parameterizedType.getActualTypeArguments()[0]) instanceof Class) {
            return (Class)elementType;
        }
        return null;
    }

    public static Class<?> getMapKeyType(Type type) {
        Type valueType;
        Class rawClazz;
        ParameterizedType parameterizedType;
        Type rawType;
        if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class && Map.class.isAssignableFrom(rawClazz = (Class)rawType) && (valueType = parameterizedType.getActualTypeArguments()[0]) instanceof Class) {
            return (Class)valueType;
        }
        return null;
    }

    public static Class<?> getMapValueType(Type type) {
        Class rawClazz;
        ParameterizedType parameterizedType;
        Type rawType;
        if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class && Map.class.isAssignableFrom(rawClazz = (Class)rawType)) {
            Type valueType = parameterizedType.getActualTypeArguments()[1];
            if (valueType instanceof Class) {
                return (Class)valueType;
            }
            if (valueType instanceof ParameterizedType) {
                return (Class)((ParameterizedType)valueType).getRawType();
            }
        }
        return null;
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> acceptableParamType) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(acceptableParamType)) continue;
            return constructor;
        }
        return null;
    }

    public static Class<?> getDeclaringClass(AnnotatedElement element) {
        if (element instanceof Class) {
            return (Class)element;
        }
        if (element instanceof Field) {
            return ((Field)element).getDeclaringClass();
        }
        if (element instanceof Method) {
            return ((Method)element).getDeclaringClass();
        }
        throw new QuickbuildException("Invalid element type: " + element.getClass().getName());
    }

    public static Object invokeStaticMethod(Class<?> clazz, String methodName) {
        Method method = ClassUtils.getMethodIfAvailable(clazz, methodName, clazz.getClass());
        if (method != null) {
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new QuickbuildException("Method '" + methodName + "' should be a static method.");
            }
            method.setAccessible(true);
            try {
                return method.invoke(null, clazz);
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
        method = ClassUtils.getMethod(clazz, methodName, new Class[0]);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new QuickbuildException("Method '" + methodName + "' should be a static method.");
        }
        method.setAccessible(true);
        try {
            return method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }

    public static String getMethodSignature(Method method) {
        String params = "";
        for (Class<?> type : method.getParameterTypes()) {
            params = params.length() == 0 ? params + type.getName() : params + ", " + type.getName();
        }
        return method.getReturnType().getName() + " " + method.getName() + "(" + params + ")";
    }

    public static <T> T instantiateClass(Class<T> cls, Object ... objects) {
        Class[] parameterTypes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            parameterTypes[i] = objects[i].getClass();
        }
        Constructor<T> constructor = ClassUtils.getConstructor(cls, parameterTypes);
        if (constructor == null) {
            StringBuilder sb = new StringBuilder();
            if (parameterTypes.length > 0) {
                for (Class type : parameterTypes) {
                    sb.append(type).append(", ");
                }
            }
            throw new IllegalArgumentException("Unable to find constructor for " + cls + " with param type: " + sb.toString());
        }
        try {
            return constructor.newInstance(objects);
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?>[] expectedTypes) {
        Constructor<?>[] constructors;
        if (expectedTypes.length == 0) {
            try {
                return clazz.getConstructor(new Class[0]);
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            if (paramTypes.length != expectedTypes.length) continue;
            boolean found = true;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramTypes[i].isAssignableFrom(expectedTypes[i])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return constructor;
        }
        return null;
    }

    public static Collection<Class<?>> findImplementations(Class<?> superClass, Class<?> packageClass) {
        HashSet classes = new HashSet();
        for (Class<?> each : ClassUtils.findSubClasses(superClass, packageClass)) {
            if (each.isInterface() || Modifier.isAbstract(each.getModifiers())) continue;
            classes.add(each);
        }
        return classes;
    }

    public static <T> Collection<Class<T>> findSubClasses(Class<T> superClass, Class<?> packageClass) {
        Preconditions.checkNotNull(superClass);
        Preconditions.checkNotNull(packageClass);
        HashSet<Class<T>> classes = new HashSet<Class<T>>();
        File location = ClassUtils.getClassFile(packageClass);
        if (location.isFile()) {
            JarFile jarFile;
            String packagePath = packageClass.getPackage().getName().replace('.', '/') + "/";
            try {
                jarFile = new JarFile(location);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                Class<?> clazz;
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(packagePath) || !entry.getName().endsWith(".class")) continue;
                String className = entry.getName().replace('/', '.');
                className = StringUtils.substringBeforeLast((String)className, (String)".");
                try {
                    clazz = packageClass.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                if (!superClass.isAssignableFrom(clazz) || clazz == superClass) continue;
                classes.add(clazz);
            }
        } else {
            String packagePath = packageClass.getPackage().getName().replace('.', File.separatorChar);
            File packageDir = new File(location, packagePath);
            if (packageDir.exists()) {
                for (File file : FileUtils.listFiles(packageDir, "**/*.class")) {
                    Class<?> clazz;
                    try {
                        String relativeName = file.getAbsolutePath().substring(packageDir.getAbsolutePath().length() + 1);
                        relativeName = relativeName.replace(File.separatorChar, '.');
                        String className = packageClass.getPackage().getName() + "." + StringUtils.substringBeforeLast((String)relativeName, (String)".");
                        clazz = packageClass.getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    if (!superClass.isAssignableFrom(clazz) || clazz == superClass) continue;
                    classes.add(clazz);
                }
            } else {
                throw new IllegalStateException("Unable to find package directory: " + packageDir.getAbsolutePath());
            }
        }
        return classes;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        Preconditions.checkArgument((!baseClass.isInterface() ? 1 : 0) != 0, (Object)"baseClass should not be an interface");
        Preconditions.checkArgument((boolean)baseClass.isAssignableFrom(childClass), (Object)"childClass should be a sub class of baseClass");
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        while (!ClassUtils.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(ClassUtils.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    private static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ClassUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ClassUtils.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public static File getClassFile(Class<?> clazz) {
        try {
            return new File(URLDecoder.decode(clazz.getProtectionDomain().getCodeSource().getLocation().getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

