/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.pmease.quickbuild.util.CategoryItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class Category<T>
extends CategoryItem<T> {
    private List<CategoryItem<T>> items = new ArrayList<CategoryItem<T>>();

    public Category() {
        this(null);
    }

    public Category(String name) {
        super(name, null);
    }

    public List<CategoryItem<T>> getItems() {
        return this.items;
    }

    public void setItems(List<CategoryItem<T>> items) {
        this.items = items;
    }

    public Category<T> getSubCategory(String[] categoryNames) {
        Category<T> subMenu = this.getSubCategory(categoryNames[0]);
        if (categoryNames.length > 1) {
            return subMenu.getSubCategory((String[])ArrayUtils.subarray((Object[])categoryNames, (int)1, (int)categoryNames.length));
        }
        return subMenu;
    }

    private Category<T> getSubCategory(String categoryName) {
        for (CategoryItem<T> item : this.items) {
            if (!(item instanceof Category) || !item.getName().equals(categoryName)) continue;
            return (Category)item;
        }
        Category<T> subCategory = new Category<T>(categoryName);
        this.items.add(subCategory);
        return subCategory;
    }

    public void sort() {
        Collections.sort(this.items, new Comparator<CategoryItem<T>>(){

            @Override
            public int compare(CategoryItem<T> item1, CategoryItem<T> item2) {
                return item1.getName().compareTo(item2.getName());
            }
        });
        for (CategoryItem<T> item : this.items) {
            if (!(item instanceof Category)) continue;
            ((Category)item).sort();
        }
    }
}

