/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Property;
import com.pmease.quickbuild.migration.MigrationListener;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.web.component.editor.EditContext;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;

public class BeanUtils {
    private static Map<String, Boolean> hasSetterCache = new ConcurrentHashMap<String, Boolean>();
    private static Map<String, Boolean> hasGetterCache = new ConcurrentHashMap<String, Boolean>();
    private static Map<String, Method> setterCache = new ConcurrentHashMap<String, Method>();
    private static Map<String, Method> getterCache = new ConcurrentHashMap<String, Method>();
    private static Map<String, List<Method>> gettersCache = new ConcurrentHashMap<String, List<Method>>();
    private static Map<String, List<Field>> fieldsCache = new ConcurrentHashMap<String, List<Field>>();
    private static Map<String, Object> fieldCache = new ConcurrentHashMap<String, Object>();

    public static boolean isGetter(Method method) {
        return (method.getName().startsWith("get") || method.getName().startsWith("is")) && !Modifier.isStatic(method.getModifiers()) && method.getParameterTypes().length == 0;
    }

    private static boolean isCacheAllowed(Class<?> clazz) {
        return !(clazz.getClassLoader() instanceof GroovyClassLoader);
    }

    public static String getMethodSuffix(String propertyName) {
        char[] chars = propertyName.toCharArray();
        if (chars[0] != '_') {
            chars[0] = Character.toUpperCase(chars[0]);
            return new String(chars);
        }
        return propertyName;
    }

    private static String getPropertyName(Class<?> clazz, String methodSuffix) {
        char[] chars = methodSuffix.toCharArray();
        if (chars[0] != '_') {
            Validate.isTrue((boolean)Character.isUpperCase(chars[0]));
            chars[0] = Character.toLowerCase(chars[0]);
            return new String(chars);
        }
        return methodSuffix;
    }

    public static List<Method> getGetters(Class<?> clazz) {
        List<Method> getters = BeanUtils.isCacheAllowed(clazz) ? gettersCache.get(clazz.getName()) : null;
        if (getters == null) {
            getters = new ArrayList<Method>();
            HashSet<String> existingNames = new HashSet<String>();
            for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
                HashMap<String, Method> declaredGetters = new HashMap<String, Method>();
                for (Method method : current.getDeclaredMethods()) {
                    Method cached;
                    if (!BeanUtils.isGetter(method) || (cached = (Method)declaredGetters.get(method.getName())) != null && (cached.getReturnType() == method.getReturnType() || !cached.getReturnType().isAssignableFrom(method.getReturnType()))) continue;
                    declaredGetters.put(method.getName(), method);
                }
                for (Method method : declaredGetters.values()) {
                    if (existingNames.contains(method.getName())) continue;
                    getters.add(method);
                    existingNames.add(method.getName());
                }
            }
            if (BeanUtils.isCacheAllowed(clazz)) {
                gettersCache.put(clazz.getName(), getters);
            }
        }
        return new ArrayList<Method>(getters);
    }

    public static List<Field> getFields(Class<?> clazz) {
        List<Field> fields = BeanUtils.isCacheAllowed(clazz) ? fieldsCache.get(clazz.getName()) : null;
        if (fields == null) {
            fields = new ArrayList<Field>();
            HashSet<String> existingNames = new HashSet<String>();
            for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
                for (Field field : current.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers()) || existingNames.contains(field.getName())) continue;
                    fields.add(field);
                    existingNames.add(field.getName());
                }
            }
            if (BeanUtils.isCacheAllowed(clazz)) {
                fieldsCache.put(clazz.getName(), fields);
            }
        }
        return new ArrayList<Field>(fields);
    }

    public static Field getField(Class<?> clazz, String propertyName) {
        String key = clazz.getName() + "#" + propertyName;
        if (BeanUtils.isCacheAllowed(clazz)) {
            Object field = fieldCache.get(key);
            if (field == null) {
                field = ObjectUtils.NULL;
                block0: for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
                    for (Field declaredField : current.getDeclaredFields()) {
                        if (Modifier.isStatic(declaredField.getModifiers()) || !propertyName.equals(declaredField.getName())) continue;
                        field = declaredField;
                        continue block0;
                    }
                }
                fieldCache.put(key, field);
            }
            if (field instanceof ObjectUtils.Null) {
                return null;
            }
            return (Field)field;
        }
        Field field = null;
        block2: for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            for (Field declaredField : current.getDeclaredFields()) {
                if (Modifier.isStatic(declaredField.getModifiers()) || !propertyName.equals(declaredField.getName())) continue;
                field = declaredField;
                continue block2;
            }
        }
        return field;
    }

    private static Method getGetterByMethodName(Class<?> clazz, String getterName) {
        Method getter = null;
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            for (Method method : current.getDeclaredMethods()) {
                if (!method.getName().equals(getterName) || Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 0 || getter != null && (getter.getReturnType() == method.getReturnType() || !getter.getReturnType().isAssignableFrom(method.getReturnType()))) continue;
                getter = method;
            }
        }
        return getter;
    }

    public static Method getGetter(Class<?> clazz, String propertyName) {
        String key = clazz.getName() + "#" + propertyName;
        Method getter = BeanUtils.isCacheAllowed(clazz) ? getterCache.get(key) : null;
        if (getter == null) {
            String methodSuffix = BeanUtils.getMethodSuffix(propertyName);
            getter = BeanUtils.getGetterByMethodName(clazz, "get" + methodSuffix);
            if (getter == null) {
                getter = BeanUtils.getGetterByMethodName(clazz, "is" + methodSuffix);
            }
            if (getter == null) {
                throw new QuickbuildException(ExceptionUtils.buildMessage("Getter not found", "class", clazz.getName(), "property", propertyName));
            }
            if (BeanUtils.isCacheAllowed(clazz)) {
                getterCache.put(key, getter);
            }
        }
        return getter;
    }

    public static boolean hasGetter(Class<?> clazz, String propertyName) {
        String key = clazz.getName() + "#" + propertyName;
        Boolean hasGetter = BeanUtils.isCacheAllowed(clazz) ? hasGetterCache.get(key) : null;
        if (hasGetter == null) {
            String methodSuffix = BeanUtils.getMethodSuffix(propertyName);
            Method getter = BeanUtils.getGetterByMethodName(clazz, "get" + methodSuffix);
            if (getter == null) {
                getter = BeanUtils.getGetterByMethodName(clazz, "is" + methodSuffix);
            }
            hasGetter = getter != null;
            if (BeanUtils.isCacheAllowed(clazz)) {
                hasGetterCache.put(key, hasGetter);
            }
        }
        return hasGetter;
    }

    public static String getPropertyName(Method getter) {
        Property property = getter.getAnnotation(Property.class);
        if (property != null) {
            return property.value();
        }
        if (getter.getName().startsWith("get")) {
            return BeanUtils.getPropertyName(getter.getDeclaringClass(), getter.getName().substring(3));
        }
        if (getter.getName().startsWith("is")) {
            return BeanUtils.getPropertyName(getter.getDeclaringClass(), getter.getName().substring(2));
        }
        throw new QuickbuildException(ExceptionUtils.buildMessage("Not recognized getter method", "class", getter.getDeclaringClass().getName(), "method", getter.getName()));
    }

    public static boolean hasSetter(Method getter) {
        String key = getter.getDeclaringClass().getName() + "#" + getter.getName();
        Boolean hasSetter = BeanUtils.isCacheAllowed(getter.getDeclaringClass()) ? hasSetterCache.get(key) : null;
        if (hasSetter == null) {
            hasSetter = false;
            String propertyName = BeanUtils.getPropertyName(getter);
            String setterName = "set" + BeanUtils.getMethodSuffix(propertyName);
            block0: for (Class<?> current = getter.getDeclaringClass(); current != null; current = current.getSuperclass()) {
                for (Method method : current.getDeclaredMethods()) {
                    if (!method.getName().equals(setterName) || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(getter.getReturnType())) continue;
                    hasSetter = true;
                    continue block0;
                }
            }
            if (BeanUtils.isCacheAllowed(getter.getDeclaringClass())) {
                hasSetterCache.put(key, hasSetter);
            }
        }
        return hasSetter;
    }

    public static Method getSetter(Method getter) {
        String key = getter.getDeclaringClass().getName() + "#" + getter.getName();
        Method setter = BeanUtils.isCacheAllowed(getter.getDeclaringClass()) ? setterCache.get(key) : null;
        if (setter == null) {
            String propertyName = BeanUtils.getPropertyName(getter);
            String setterName = "set" + BeanUtils.getMethodSuffix(propertyName);
            for (Class<?> current = getter.getDeclaringClass(); current != null; current = current.getSuperclass()) {
                for (Method method : current.getDeclaredMethods()) {
                    if (!method.getName().equals(setterName) || Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(getter.getReturnType()) || setter != null && !setter.getParameterTypes()[0].isAssignableFrom(method.getParameterTypes()[0])) continue;
                    setter = method;
                }
            }
            if (setter == null) {
                throw new QuickbuildException("Can not find setter for property '" + propertyName + "'.");
            }
            if (BeanUtils.isCacheAllowed(getter.getDeclaringClass())) {
                setterCache.put(key, setter);
            }
        }
        return setter;
    }

    public static void copyFields(Object src, Object dest, Class<?> clazz) {
        for (Field field : BeanUtils.getFields(clazz)) {
            try {
                field.setAccessible(true);
                field.set(dest, field.get(src));
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
    }

    public static void validate(Object bean) {
        new EditContext(bean).validate(true);
    }

    public static void writeFile(Object bean, File file) {
        FileUtils.writeFile(file, VersionedDocument.fromBean(bean).toXML(), "UTF-8");
    }

    public static Object readFile(File file, MigrationListener listener, Class<?> beanClass) {
        String xml = FileUtils.readFileAsString(file, "UTF-8");
        return VersionedDocument.fromXML(xml).toBean(listener, beanClass);
    }

    public static Object readFile(File file, MigrationListener listener) {
        return BeanUtils.readFile(file, listener, null);
    }

    public static Object readFile(File file) {
        return BeanUtils.readFile(file, null);
    }

    public static Object clone(Object bean) {
        return VersionedDocument.fromBean(bean).toBean();
    }

    public static void copyFields(Object source, Object dest, String[] ignores) {
        if (source == null || dest == null) {
            return;
        }
        for (Field field : BeanUtils.getFields(dest.getClass())) {
            if (ArrayUtils.contains((Object[])ignores, (Object)field.getName())) continue;
            field.setAccessible(true);
            try {
                field.set(dest, field.get(source));
            }
            catch (IllegalArgumentException e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
            catch (IllegalAccessException e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
    }

    public static <T> T newInstance(T source, String[] ignores, Object ... objects) {
        Object dest = ClassUtils.instantiateClass(source.getClass(), objects);
        BeanUtils.copyFields(source, dest, ignores);
        return (T)dest;
    }
}

