/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.pmease.quickbuild.util.BackoffException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackoffCallable<T>
implements Callable<T> {
    private static final Logger logger = LoggerFactory.getLogger(BackoffCallable.class);
    private final long backoffTime;
    private final long giveupTime;
    private final Callable<T> delegate;

    public BackoffCallable(Callable<T> delegate, long backoffTime, long giveupTime) {
        this.delegate = delegate;
        this.backoffTime = backoffTime;
        this.giveupTime = giveupTime;
    }

    @Override
    public T call() throws Exception {
        long start = System.currentTimeMillis();
        long waitTime = 0L;
        while (true) {
            try {
                return this.delegate.call();
            }
            catch (BackoffException e) {
                if (System.currentTimeMillis() - start > this.giveupTime) {
                    throw e;
                }
                logger.warn("Delegation call failed with backing off exception, sleep " + (waitTime += this.backoffTime) / 1000L + " seconds to retry...");
                Thread.sleep(waitTime);
                continue;
            }
            break;
        }
    }
}

