/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.typeconverter;

import com.google.inject.Inject;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.typeconverter.ConversionException;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.MultiUserChoiceEditor;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class UserListConverter
implements TypeConverter {
    @Inject
    private UserManager userManager;

    @Override
    public boolean accept(Method getter) {
        return List.class.isAssignableFrom(getter.getReturnType()) && ClassUtils.getCollectionElementType(getter.getGenericReturnType()) == User.class;
    }

    @Override
    public Object toObject(Class<?> type, String string) {
        ArrayList<User> users = new ArrayList<User>();
        if (StringUtils.isNotBlank((String)string)) {
            List<String> values = StringUtils.splitAndTrim(string);
            for (String value : values) {
                try {
                    Long userId = Long.valueOf(value);
                    User user = (User)this.userManager.get(userId);
                    if (user == null) continue;
                    users.add(user);
                }
                catch (NumberFormatException e) {
                    throw new ConversionException("Invalid user id '" + value + "'.");
                }
            }
        }
        return users;
    }

    @Override
    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        List users = (List)obj;
        for (User user : users) {
            values.add(user.getId().toString());
        }
        return StringUtils.join(values.iterator(), (String)",");
    }

    @Override
    public TypeEditor createEditor(String id, Class<?> beanType, EditContext.EditableProperty property) {
        return new MultiUserChoiceEditor(id, (Class)beanType, property);
    }
}

