/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.typeconverter;

import com.google.inject.Inject;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.typeconverter.ConversionException;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import com.pmease.quickbuild.web.component.editor.UserChoiceEditor;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;

public class UserConverter
implements TypeConverter {
    @Inject
    private UserManager userManager;

    @Override
    public boolean accept(Method getter) {
        return getter.getReturnType() == User.class;
    }

    @Override
    public TypeEditor createEditor(String id, Class<?> beanType, EditContext.EditableProperty property) {
        return new UserChoiceEditor(id, (Class)beanType, property);
    }

    @Override
    public Object toObject(Class<?> type, String string) {
        User user = null;
        if (StringUtils.isNotBlank((String)string) && (user = this.userManager.get(string)) == null) {
            throw new ConversionException("Can not find user '" + string + "'.");
        }
        return user;
    }

    @Override
    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return ((User)obj).getName();
    }
}

