/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.typeconverter;

import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Choices;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.MultiChoiceEditor;
import com.pmease.quickbuild.web.component.editor.StringEditor;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StringListConverter
implements TypeConverter {
    @Override
    public boolean accept(Method getter) {
        return (List.class.isAssignableFrom(getter.getReturnType()) || Set.class.isAssignableFrom(getter.getReturnType())) && ClassUtils.getCollectionElementType(getter.getGenericReturnType()) == String.class;
    }

    @Override
    public Object toObject(Class<?> type, String string) {
        if (List.class.isAssignableFrom(type)) {
            if (string == null) {
                return new ArrayList();
            }
            return new ArrayList<String>(StringUtils.splitAndTrim(string));
        }
        if (string == null) {
            return new HashSet();
        }
        return new HashSet<String>(StringUtils.splitAndTrim(string));
    }

    @Override
    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof List)) {
            ArrayList list = new ArrayList((Collection)obj);
            Collections.sort(list);
            return StringUtils.join(list, (String)",").trim();
        }
        return StringUtils.join((Collection)((List)obj), (String)",").trim();
    }

    @Override
    public TypeEditor createEditor(String id, Class<?> beanType, EditContext.EditableProperty property) {
        Method getter = BeanUtils.getGetter(beanType, property.getName());
        if (getter.getAnnotation(ChoiceProvider.class) != null || getter.getAnnotation(Choices.class) != null) {
            return new MultiChoiceEditor(id, (Class)beanType, property);
        }
        return new StringEditor(id, (Class)beanType, property);
    }
}

