/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.typeconverter;

import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Choices;
import com.pmease.quickbuild.annotation.Color;
import com.pmease.quickbuild.annotation.ConfigurationPath;
import com.pmease.quickbuild.annotation.ConfigurationPaths;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.web.component.editor.ChoiceEditor;
import com.pmease.quickbuild.web.component.editor.ColorEditor;
import com.pmease.quickbuild.web.component.editor.ConfigurationPathEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.ExpressionEditor;
import com.pmease.quickbuild.web.component.editor.MultiConfigurationPathEditor;
import com.pmease.quickbuild.web.component.editor.StringEditor;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import java.lang.reflect.Method;

public class StringConverter
implements TypeConverter {
    @Override
    public boolean accept(Method getter) {
        if (getter.getAnnotation(Password.class) != null) {
            return false;
        }
        return getter.getReturnType() == String.class;
    }

    @Override
    public Object toObject(Class<?> type, String string) {
        return string;
    }

    @Override
    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    @Override
    public TypeEditor createEditor(String id, Class<?> beanType, EditContext.EditableProperty property) {
        Method getter = BeanUtils.getGetter(beanType, property.getName());
        if (getter.getAnnotation(ConfigurationPath.class) != null) {
            return new ConfigurationPathEditor(id, (Class)beanType, property);
        }
        if (getter.getAnnotation(ConfigurationPaths.class) != null) {
            return new MultiConfigurationPathEditor(id, (Class)beanType, property);
        }
        if (getter.getAnnotation(Color.class) != null) {
            return new ColorEditor(id, (Class)beanType, property);
        }
        if (getter.getAnnotation(Expressions.class) != null) {
            return new ExpressionEditor(id, beanType, property);
        }
        if (getter.getAnnotation(ExpressionProvider.class) != null) {
            return new ExpressionEditor(id, beanType, property);
        }
        if (getter.getAnnotation(ChoiceProvider.class) != null || getter.getAnnotation(Choices.class) != null) {
            return new ChoiceEditor(id, (Class)beanType, property);
        }
        return new StringEditor(id, (Class)beanType, property);
    }
}

