/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.typeconverter;

import com.google.inject.Inject;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.ConfigurationId;
import com.pmease.quickbuild.annotation.Numeric;
import com.pmease.quickbuild.typeconverter.ConversionException;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.web.component.editor.ConfigurationIdEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.StringEditor;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import java.lang.reflect.Method;

public class NumericConverter
implements TypeConverter {
    @Inject
    private ScriptEngine scriptEngine;

    @Override
    public boolean accept(Method getter) {
        Class<?> type = getter.getReturnType();
        return type == Integer.TYPE || type == Long.TYPE || type == Integer.class || type == Long.class || type == Float.TYPE || type == Float.class || type == Double.TYPE || type == Double.class || getter.getAnnotation(Numeric.class) != null;
    }

    @Override
    public Object toObject(Class<?> type, String string) {
        if (string == null) {
            if (type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE) {
                throw new ConversionException("Should not be empty.");
            }
            return null;
        }
        try {
            if (type == Integer.TYPE || type == Integer.class) {
                return Integer.parseInt(string);
            }
            if (type == Long.TYPE || type == Long.class) {
                return Long.parseLong(string);
            }
            if (type == Float.TYPE || type == Float.class) {
                return Float.valueOf(Float.parseFloat(string));
            }
            if (type == Double.TYPE || type == Double.class) {
                return Double.parseDouble(string);
            }
            if (!this.scriptEngine.interpolative(string)) {
                Long.parseLong(string);
            }
            return string;
        }
        catch (NumberFormatException e) {
            throw new ConversionException("Invalid numeric value.");
        }
    }

    @Override
    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    @Override
    public TypeEditor createEditor(String id, Class<?> beanType, EditContext.EditableProperty property) {
        Method getter = BeanUtils.getGetter(beanType, property.getName());
        if (getter.getAnnotation(ConfigurationId.class) != null) {
            return new ConfigurationIdEditor(id, (Class)beanType, property);
        }
        return new StringEditor(id, (Class)beanType, property);
    }
}

