/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.typeconverter;

import com.google.inject.Inject;
import com.pmease.quickbuild.entitymanager.GroupManager;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.typeconverter.ConversionException;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.MultiGroupChoiceEditor;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class GroupListConverter
implements TypeConverter {
    @Inject
    private GroupManager groupManager;

    @Override
    public boolean accept(Method getter) {
        return List.class.isAssignableFrom(getter.getReturnType()) && ClassUtils.getCollectionElementType(getter.getGenericReturnType()) == Group.class;
    }

    public Object toObject(Method getter, String string) {
        return this.toObject(getter.getReturnType(), string);
    }

    @Override
    public Object toObject(Class<?> type, String string) {
        ArrayList<Group> groups = new ArrayList<Group>();
        if (StringUtils.isNotBlank((String)string)) {
            List<String> values = StringUtils.splitAndTrim(string);
            for (String value : values) {
                try {
                    Long groupId = Long.valueOf(value);
                    if (groupId.equals(0L)) {
                        groups.add(null);
                        continue;
                    }
                    Group group = (Group)this.groupManager.get(groupId);
                    if (group == null) continue;
                    groups.add(group);
                }
                catch (NumberFormatException e) {
                    throw new ConversionException("Invalid group id '" + value + "'.");
                }
            }
        }
        return groups;
    }

    @Override
    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        List groups = (List)obj;
        for (Group group : groups) {
            if (group != null) {
                values.add(group.getId().toString());
                continue;
            }
            values.add("0");
        }
        return StringUtils.join(values.iterator(), (String)",");
    }

    @Override
    public TypeEditor createEditor(String id, Class<?> beanType, EditContext.EditableProperty property) {
        return new MultiGroupChoiceEditor(id, (Class)beanType, property);
    }
}

