/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.typeconverter;

import com.pmease.quickbuild.typeconverter.ConversionException;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.EnumEditor;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import java.lang.reflect.Method;

public class EnumConverter
implements TypeConverter {
    @Override
    public boolean accept(Method getter) {
        return Enum.class.isAssignableFrom(getter.getReturnType());
    }

    public Object toObject(Class type, String string) {
        if (string == null) {
            return null;
        }
        try {
            return Enum.valueOf(type, string);
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException("Invalid value of enum '" + type.getName() + "'.");
        }
    }

    @Override
    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    @Override
    public TypeEditor createEditor(String id, Class<?> beanType, EditContext.EditableProperty property) {
        return new EnumEditor(id, (Class)beanType, property);
    }
}

