/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.typeconverter;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.typeconverter.TypeConverterRegistry;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.framework.BundleContext;

@Singleton
public class DefaultTypeConverterRegistry
implements TypeConverterRegistry {
    private List<TypeConverter> typeConverters = new ArrayList<TypeConverter>();

    @Inject
    public DefaultTypeConverterRegistry(BundleContext bundleContext) {
        Collection<Class<?>> typeConverterClasses = ClassUtils.findImplementations(TypeConverter.class, TypeConverter.class);
        for (Class<?> typeConverterClass : typeConverterClasses) {
            TypeConverter typeConverter;
            try {
                typeConverter = (TypeConverter)typeConverterClass.newInstance();
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
            Quickbuild.injector.injectMembers((Object)typeConverter);
            this.typeConverters.add(typeConverter);
        }
    }

    @Override
    public TypeConverter getTypeConverter(Method getter) {
        for (TypeConverter typeConverter : this.typeConverters) {
            if (!typeConverter.accept(getter)) continue;
            return typeConverter;
        }
        return null;
    }

    @Override
    public List<TypeConverter> getTypeConverters() {
        return this.typeConverters;
    }
}

