/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.typeconverter;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.DateTime;
import com.pmease.quickbuild.typeconverter.ConversionException;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.component.editor.DateTimeEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateTimeConverter
implements TypeConverter {
    @Override
    public boolean accept(Method getter) {
        return getter.getAnnotation(DateTime.class) != null && getter.getReturnType() == Date.class;
    }

    @Override
    public Object toObject(Class<?> type, String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            sdf.setTimeZone(Context.getTimeZone());
            return sdf.parse(string);
        }
        catch (Exception e) {
            throw new ConversionException("Incorrect date time value. Expected date time format: yyyy-MM-dd HH:mm, for example: 2009-08-01 13:45");
        }
    }

    @Override
    public String toString(Object obj) {
        if (obj != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            sdf.setTimeZone(Context.getTimeZone());
            return sdf.format(obj);
        }
        return null;
    }

    @Override
    public TypeEditor createEditor(String id, Class<?> beanType, EditContext.EditableProperty property) {
        return new DateTimeEditor(id, beanType, property);
    }
}

