/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.typeconverter;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.DateTime;
import com.pmease.quickbuild.annotation.Time;
import com.pmease.quickbuild.typeconverter.ConversionException;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.web.component.editor.DateEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.joda.time.format.DateTimeFormat;

public class DateConverter
implements TypeConverter {
    @Override
    public boolean accept(Method getter) {
        return getter.getAnnotation(Time.class) == null && getter.getAnnotation(DateTime.class) == null && getter.getReturnType() == Date.class;
    }

    @Override
    public Object toObject(Class<?> type, String string) {
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sdf.setTimeZone(Context.getTimeZone());
            DateTimeFormat.forPattern((String)"yyyy-MM-dd").parseDateTime(string);
            return sdf.parse(string);
        }
        catch (Exception e) {
            throw new ConversionException("Incorrect date value. Expected date format: yyyy-MM-dd, for example: 2009-08-01");
        }
    }

    @Override
    public String toString(Object obj) {
        if (obj != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sdf.setTimeZone(Context.getTimeZone());
            return sdf.format(obj);
        }
        return null;
    }

    @Override
    public TypeEditor createEditor(String id, Class<?> beanType, EditContext.EditableProperty property) {
        return new DateEditor(id, (Class)beanType, property);
    }
}

