/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.typeconverter;

import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.typeconverter.ConversionException;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.MultiConfigurationChoiceEditor;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationListConverter
implements TypeConverter {
    @Override
    public boolean accept(Method getter) {
        return List.class.isAssignableFrom(getter.getReturnType()) && ClassUtils.getCollectionElementType(getter.getGenericReturnType()) == Configuration.class;
    }

    @Override
    public Object toObject(Class<?> type, String string) {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        if (StringUtils.isNotBlank((String)string)) {
            List<String> values = StringUtils.splitAndTrim(string);
            for (String value : values) {
                if (!StringUtils.isNotBlank((String)value)) continue;
                Configuration configuration = ConfigurationManager.instance.get(string);
                if (configuration == null) {
                    throw new ConversionException("Can not find configuration '" + string + "'.");
                }
                configurations.add(configuration);
            }
        }
        return configurations;
    }

    @Override
    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        List configurations = (List)obj;
        for (Configuration configuration : configurations) {
            values.add(configuration.getPathName());
        }
        return StringUtils.join(values.iterator(), (String)",");
    }

    @Override
    public TypeEditor createEditor(String id, Class<?> beanType, EditContext.EditableProperty property) {
        return new MultiConfigurationChoiceEditor(id, (Class)beanType, property);
    }
}

