/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.typeconverter;

import com.pmease.quickbuild.typeconverter.ConversionException;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.web.component.editor.BooleanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.component.editor.NullableBooleanEditor;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import java.lang.reflect.Method;

public class BooleanConverter
implements TypeConverter {
    @Override
    public boolean accept(Method getter) {
        return getter.getReturnType() == Boolean.TYPE || getter.getReturnType() == Boolean.class;
    }

    @Override
    public Object toObject(Class<?> type, String string) {
        if (string == null) {
            return null;
        }
        if ("yes".equalsIgnoreCase(string) || "y".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string) || "t".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("no".equalsIgnoreCase(string) || "n".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string) || "f".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        throw new ConversionException("Invalid boolean value: " + string);
    }

    @Override
    public String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (((Boolean)obj).booleanValue()) {
            return "yes";
        }
        return "no";
    }

    @Override
    public TypeEditor createEditor(String id, Class<?> beanType, EditContext.EditableProperty property) {
        if (EditorHelper.isPropertyRequired(beanType, property.getName())) {
            return new BooleanEditor(id, (Class)beanType, property);
        }
        return new NullableBooleanEditor(id, (Class)beanType, property);
    }
}

