/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.taskschedule.schedule;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import java.io.Serializable;
import org.quartz.Trigger;

@ScriptApi
public abstract class Schedule
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private boolean paused;
    private int randomRange = 60;

    @Editable(order=1000, description="Whether or not this schedule is paused.")
    @ScriptApi(value="Is this schedule paused?")
    public boolean isPaused() {
        return this.paused;
    }

    @ScriptApi(value="Set pause flag of the schedule.")
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Editable(order=1005, description="Specify randome range in seconds. If set to a non-zero value, QuickBuild will trigger the build within the period of time randomized by this value when scheduled time reaches, instead of triggering the build right away. This can effectively avoid the situation that all configurations are triggered at the same moment to put a heavy burden on the system when they all inherit the same schedule.")
    public int getRandomRange() {
        return this.randomRange;
    }

    public void setRandomRange(int randomRange) {
        this.randomRange = randomRange;
    }

    public abstract Trigger getTrigger();

    public Schedule clone() {
        Schedule schedule = this.cloneSchedule();
        schedule.setPaused(this.isPaused());
        schedule.setRandomRange(this.getRandomRange());
        return schedule;
    }

    protected abstract Schedule cloneSchedule();
}

