/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.taskschedule.schedule;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Numeric;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.taskschedule.schedule.Schedule;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.hibernate.validator.constraints.NotEmpty;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

@Editable(name="Periodical schedule", order=200)
@ScriptApi
public class PeriodicalSchedule
extends Schedule {
    private static final long serialVersionUID = 1L;
    private String repeatInterval = "300";

    @Editable(order=100, description="Specify repeat interval in seconds.")
    @ScriptApi(value="Get repeat interval of this schedule in seconds.")
    @Scriptable
    @NotEmpty
    @Numeric
    public String getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setRepeatInterval(String repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    @Override
    public Trigger getTrigger() {
        SimpleTrigger trigger = new SimpleTrigger();
        ScriptEngine scriptEngine = Quickbuild.getInstance(ScriptEngine.class);
        trigger.setRepeatInterval(Long.parseLong(scriptEngine.interpolate(this.getRepeatInterval(), Context.buildEvalContext(this, null))) * 1000L);
        trigger.setStartTime(new Date(System.currentTimeMillis() + trigger.getRepeatInterval()));
        trigger.setRepeatCount(-1);
        return trigger;
    }

    public String toString() {
        if (Context.get() != null) {
            try {
                String repeatInterval = ScriptEngine.instance.interpolate(this.repeatInterval, Context.buildEvalContext(this, null));
                return "Every " + DurationFormatUtils.formatDurationWords((long)(Long.parseLong(repeatInterval) * 1000L), (boolean)true, (boolean)true);
            }
            catch (Exception e) {
                Context.getLogger().error("Error evaluating schedule.", (Throwable)e);
            }
        }
        return "Every " + this.repeatInterval + " seconds";
    }

    public boolean equals(Object other) {
        if (!(other instanceof PeriodicalSchedule)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        PeriodicalSchedule otherSchedule = (PeriodicalSchedule)other;
        return new EqualsBuilder().append(this.isPaused(), otherSchedule.isPaused()).append((Object)this.getRepeatInterval(), (Object)otherSchedule.getRepeatInterval()).append(this.getRandomRange(), otherSchedule.getRandomRange()).isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 37);
        builder.append(this.isPaused());
        builder.append((Object)this.getRepeatInterval());
        builder.append(this.getRandomRange());
        return builder.toHashCode();
    }

    @Override
    public Schedule cloneSchedule() {
        PeriodicalSchedule schedule = new PeriodicalSchedule();
        schedule.setRepeatInterval(this.getRepeatInterval());
        return schedule;
    }
}

