/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.taskschedule.schedule;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.taskschedule.TaskScheduler;
import com.pmease.quickbuild.taskschedule.schedule.Schedule;
import com.pmease.quickbuild.validation.ErrorContext;
import com.pmease.quickbuild.validation.Validatable;
import java.text.ParseException;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.validator.constraints.NotEmpty;
import org.quartz.CronTrigger;
import org.quartz.Trigger;

@Editable(name="Cron schedule", order=300)
@ScriptApi
public class CronSchedule
extends Schedule
implements Validatable {
    private static final long serialVersionUID = 1L;
    private String expression = "0 0 1 * * ?";

    @Editable(order=100, description="Specify cron expression for this schedule, the format is <b>&lt;seconds&gt; &lt;minutes&gt; &lt;hours&gt; &lt;day-of-month&gt; &lt;month&gt; &lt;day-of-week&gt;</b>. For example, <b>0 0 1 * * ?</b> means 1:00am every day. For details of the format, refer to <a href='http://www.quartz-scheduler.org/documentation/quartz-2.x/tutorials/tutorial-lesson-06'>Quartz tutorial</a>.<br><b>NOTE: </b> the cron expression should be specified using local time of the server even if time zone detection is enabled in system setting.")
    @Scriptable
    @ScriptApi(value="Get cron expression of this schedule.")
    @NotEmpty
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public Trigger getTrigger() {
        CronTrigger trigger = new CronTrigger();
        try {
            ScriptEngine scriptEngine = Quickbuild.getInstance(ScriptEngine.class);
            trigger.setCronExpression(scriptEngine.interpolate(this.getExpression(), Context.buildEvalContext(this, null)));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        trigger.setStartTime(new Date(System.currentTimeMillis()));
        return trigger;
    }

    public String toString() {
        if (Context.get() != null) {
            try {
                return "At " + ScriptEngine.instance.interpolate(this.expression, Context.buildEvalContext(this, null));
            }
            catch (Exception e) {
                Context.getLogger().error("Error evaluating schedule.", (Throwable)e);
            }
        }
        return "At " + this.expression;
    }

    @Override
    public void validate(Set<String> properties, ErrorContext errorContext) {
        if (properties.contains("expression")) {
            errorContext.setError("expression", Quickbuild.getInstance(TaskScheduler.class).checkCronExpression(this.getExpression()));
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof CronSchedule)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        CronSchedule otherSchedule = (CronSchedule)other;
        return new EqualsBuilder().append(this.isPaused(), otherSchedule.isPaused()).append((Object)this.getExpression(), (Object)otherSchedule.getExpression()).append(this.getRandomRange(), otherSchedule.getRandomRange()).isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 37);
        builder.append(this.isPaused());
        builder.append((Object)this.getExpression());
        builder.append(this.getRandomRange());
        return builder.toHashCode();
    }

    @Override
    public Schedule cloneSchedule() {
        CronSchedule schedule = new CronSchedule();
        schedule.setExpression(this.getExpression());
        return schedule;
    }
}

