/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.taskschedule;

import com.google.inject.Singleton;
import com.pmease.quickbuild.taskschedule.SchedulableTask;
import com.pmease.quickbuild.taskschedule.TaskScheduler;
import java.text.ParseException;
import java.util.Properties;
import java.util.UUID;
import org.quartz.CronExpression;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

@Singleton
public class DefaultTaskScheduler
implements TaskScheduler {
    private static final String DEFAULT_GROUP = "default";
    private static final String TASK_INSTANCE_KEY = "task";
    private Scheduler quartz;

    public DefaultTaskScheduler() {
        StdSchedulerFactory schedFactory = new StdSchedulerFactory();
        Properties props = new Properties();
        props.setProperty("org.quartz.scheduler.instanceName", "DefaultQuartzScheduler");
        props.setProperty("org.quartz.scheduler.rmi.export", "false");
        props.setProperty("org.quartz.scheduler.rmi.proxy", "false");
        props.setProperty("org.quartz.scheduler.wrapJobExecutionInUserTransaction", "false");
        props.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        props.setProperty("org.quartz.threadPool.threadCount", "50");
        props.setProperty("org.quartz.jobStore.misfireThreshold", "60000");
        props.setProperty("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
        try {
            schedFactory.initialize(props);
            this.quartz = schedFactory.getScheduler();
            this.quartz.start();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized String schedule(SchedulableTask task) {
        try {
            JobDetail jobDetail = new JobDetail();
            jobDetail.setDurability(true);
            jobDetail.setGroup(DEFAULT_GROUP);
            jobDetail.setName(UUID.randomUUID().toString());
            jobDetail.setJobClass(HelperTask.class);
            Trigger trigger = task.getSchedule().getTrigger();
            trigger.setGroup(DEFAULT_GROUP);
            trigger.setName(jobDetail.getName());
            JobDataMap data = new JobDataMap();
            data.put((Object)TASK_INSTANCE_KEY, (Object)task);
            trigger.setJobDataMap(data);
            this.quartz.scheduleJob(jobDetail, trigger);
            return trigger.getName();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void unschedule(String taskId) {
        try {
            this.quartz.deleteJob(taskId, DEFAULT_GROUP);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.quartz.shutdown();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isStarted() {
        return this.quartz != null;
    }

    @Override
    public String checkCronExpression(String cronExpression) {
        try {
            new CronExpression(cronExpression);
            return null;
        }
        catch (ParseException e) {
            return e.getMessage();
        }
    }

    public static class HelperTask
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            SchedulableTask task = (SchedulableTask)context.getTrigger().getJobDataMap().get((Object)DefaultTaskScheduler.TASK_INSTANCE_KEY);
            task.execute();
        }
    }
}

