/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.stepsupport;

import com.pmease.quickbuild.annotation.ScriptApi;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@ScriptApi(value="This class stores execution information of a step.")
public class StepRuntime
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Status status = Status.IDLE;
    private String nodeAddress;
    private Map<String, Integer> resources;
    private String errorMessage;
    private Long waitDuration;
    private Long duration;
    private Object customData;

    @ScriptApi(value="Get execution status of the step. Will not be null.")
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @ScriptApi(value="Get address of the node running this step.")
    public String getNodeAddress() {
        return this.nodeAddress;
    }

    public void setNodeAddress(String nodeAddress) {
        this.nodeAddress = nodeAddress;
    }

    public Map<String, Integer> getResources() {
        if (this.resources == null) {
            this.resources = new HashMap<String, Integer>();
        }
        return this.resources;
    }

    public void setResources(Map<String, Integer> resources) {
        this.resources = resources;
    }

    @ScriptApi(value="Get error message of this step. Null if no errors.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @ScriptApi(value="Get duration of the step. Null if unknown.")
    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public Object getCustomData() {
        return this.customData;
    }

    public void setCustomData(Object customData) {
        this.customData = customData;
    }

    @ScriptApi(value="Get wait duration of this step in milliseconds. Null if unknown.")
    public Long getWaitDuration() {
        return this.waitDuration;
    }

    public void setWaitDuration(Long waitDuration) {
        this.waitDuration = waitDuration;
    }

    public StepRuntime clone() {
        StepRuntime clone = new StepRuntime();
        clone.customData = this.customData;
        clone.duration = this.duration;
        clone.waitDuration = this.waitDuration;
        clone.errorMessage = this.errorMessage;
        clone.nodeAddress = this.nodeAddress;
        clone.resources = this.resources;
        clone.status = this.status;
        return clone;
    }

    public static enum Status {
        IDLE,
        WAITING,
        SUCCESSFUL,
        FAILED,
        TIMEOUT,
        CANCELLED,
        RUNNING;

    }
}

