/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.stepsupport;

import com.pmease.quickbuild.BuildAwareJob;
import com.pmease.quickbuild.BuildAwareTask;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridJob;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.stepsupport.CompositeStep;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.stepsupport.StepAwareJob;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.stepsupport.StepProcessJob;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.stepsupport.StepVisitor;
import com.pmease.quickbuild.variable.VariableWrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class StepProcessTask
extends BuildAwareTask<Collection<StepPath>, Void> {
    public StepProcessTask(Build build) {
        super(build);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void reduce(Collection<GridJob> jobs) {
        final Build build = this.getBuild();
        Throwable e = null;
        for (GridJob job : jobs) {
            if (job.getException() != null) {
                e = job.getException();
                continue;
            }
            StepAwareJob stepAwareJob = (StepAwareJob)job;
            Build jobBuild = stepAwareJob.getBuild();
            BuildRequest buildRequest = build.getRequest();
            synchronized (buildRequest) {
                for (Map.Entry<String, Object> entry : jobBuild.getReports().entrySet()) {
                    Object oldData = build.getReports().get(entry.getKey());
                    Object newData = entry.getValue();
                    if (oldData instanceof Map && newData instanceof Map) {
                        Map oldMap = (Map)oldData;
                        Map newMap = (Map)newData;
                        oldMap.putAll(newMap);
                        continue;
                    }
                    if (oldData instanceof Collection && newData instanceof Collection) {
                        Collection oldCollection = (Collection)oldData;
                        Collection newCollection = (Collection)newData;
                        for (Object element : newCollection) {
                            if (oldCollection.contains(element)) continue;
                            oldCollection.add(element);
                        }
                        continue;
                    }
                    build.getReports().put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, Object> entry : jobBuild.getVariables().entrySet()) {
                    String varName = entry.getKey();
                    VariableWrapper var = (VariableWrapper)entry.getValue();
                    if (build.getVariables().get(varName) != null) {
                        if (!var.isDirty()) continue;
                        build.getVariables().put(varName, var);
                        continue;
                    }
                    build.getVariables().put(varName, var);
                }
                Map<String, Repository<?>> repositories = build.getRepositoryCache();
                for (Repository<?> repository : jobBuild.getRepositoryCache().values()) {
                    if (repository == null) continue;
                    Repository<?> oldRepository = repositories.get(repository.getName());
                    if (oldRepository != null) {
                        if (!repository.isDirty()) continue;
                        repositories.put(repository.getName(), repository);
                        build.getRepositoryRuntimes().put(repository.getName(), repository.getRuntime());
                        repository.setBuild(build);
                        continue;
                    }
                    repositories.put(repository.getName(), repository);
                    build.getRepositoryRuntimes().put(repository.getName(), repository.getRuntime());
                    repository.setBuild(build);
                }
                StepPath stepPath = stepAwareJob.getStepPath();
                Step jobStep = jobBuild.getStep(stepPath);
                Validate.notNull((Object)jobStep);
                build.getStepCache().put(stepPath, jobStep);
                build.getStepRuntimes().put(stepPath.toString(), jobStep.getRuntime());
                if (jobStep instanceof CompositeStep) {
                    StepVisitor stepVisitor = new StepVisitor(){

                        @Override
                        public Step visit(Step step) {
                            StepRuntime originalStepRuntime;
                            Step originalStep = build.getStepCache().get(step.getPath());
                            if (originalStep == null || originalStep.getStatus() == StepRuntime.Status.IDLE || step.getStatus() != StepRuntime.Status.IDLE) {
                                build.getStepCache().put(step.getPath(), step);
                            }
                            if ((originalStepRuntime = build.getStepRuntimes().get(step.getPath().toString())) == null || originalStepRuntime.getStatus() == StepRuntime.Status.IDLE || step.getRuntime().getStatus() != StepRuntime.Status.IDLE) {
                                build.getStepRuntimes().put(step.getPath().toString(), step.getRuntime());
                            }
                            return null;
                        }
                    };
                    ((CompositeStep)jobStep).visitChildren(stepVisitor);
                }
                for (Step step : build.getStepCache().values()) {
                    if (step == null) continue;
                    step.setBuild(build);
                }
            }
        }
        if (e != null) {
            throw new RuntimeException("Error executing step process job.", e);
        }
        return null;
    }

    @Override
    protected Map<BuildAwareJob, GridNode> map(Collection<StepPath> arg) {
        HashMap<BuildAwareJob, GridNode> map = new HashMap<BuildAwareJob, GridNode>();
        for (StepPath each : arg) {
            map.put(new StepProcessJob(this.getId(), this.getBuild(), each), Grid.instance.getLocalNode());
        }
        return map;
    }
}

