/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.stepsupport;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridTaskFuture;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.stepsupport.StepAwareJob;
import com.pmease.quickbuild.stepsupport.StepExecutionTask;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.variable.VariableWrapper;
import java.util.concurrent.TimeoutException;

public class StepProcessJob
extends StepAwareJob {
    private static final long serialVersionUID = 1L;

    public StepProcessJob(String taskId, Build build, StepPath stepPath) {
        super(taskId, build, stepPath);
    }

    @Override
    protected void executeStepAwareJob() {
        Step step = this.getStep();
        for (VariableWrapper variableWrapper : Context.getBuild().getVariables().values()) {
            variableWrapper.setDirty(false);
        }
        for (Repository repository : Context.getBuild().getRepositoryCache().values()) {
            if (repository == null) continue;
            repository.setDirty(false);
        }
        Context.getLogger().info("Checking step execute condition...");
        if (step.shouldExecute()) {
            GridTaskFuture<Void> taskFuture;
            Context.getLogger().info("Step execute condition satisfied, executing...");
            try {
                taskFuture = Grid.instance.execute(new StepExecutionTask(Context.getBuild()), step.getPath());
            }
            catch (Exception exception) {
                Quickbuild.getServerService().stepSkipped(this.getBuild().getId(), step.getPath());
                throw ExceptionUtils.wrapAsUnchecked(exception);
            }
            int n = Integer.parseInt(step.getTimeout());
            if (n == 0) {
                taskFuture.get();
            } else {
                taskFuture.get(n * 1000);
                if (taskFuture.getException() != null) {
                    if (taskFuture.getException() instanceof TimeoutException) {
                        step.setStatus(StepRuntime.Status.TIMEOUT);
                    } else {
                        step.setStatus(StepRuntime.Status.CANCELLED);
                    }
                }
            }
        } else {
            Context.getLogger().info("Step execute condition not satisfied, step will be skipped.");
            Quickbuild.getServerService().stepSkipped(this.getBuild().getId(), step.getPath());
        }
    }
}

