/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.stepsupport;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

@ScriptApi
public class StepPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final char SEPARATOR = '>';
    private List<Element> elements = new ArrayList<Element>();

    public List<Element> getElements() {
        return this.elements;
    }

    public StepPath getParent() {
        if (this.elements.size() < 2) {
            return null;
        }
        StepPath parent = new StepPath();
        parent.getElements().addAll(this.elements);
        parent.getElements().remove(this.elements.size() - 1);
        return parent;
    }

    public boolean contains(StepPath path) {
        if (path == null) {
            return false;
        }
        String str = this.toString();
        String pathStr = path.toString();
        if (!pathStr.startsWith(str) || pathStr.length() == str.length()) {
            return false;
        }
        return pathStr.charAt(str.length()) == '>';
    }

    public Element getLastElement() {
        Validate.notEmpty(this.elements);
        return this.elements.get(this.elements.size() - 1);
    }

    @ScriptApi(value="Convert this path to a string.")
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Element element : this.elements) {
            buffer.append(element.toString() + '>');
        }
        return StringUtils.stripEnd((String)buffer.toString(), (String)String.valueOf('>'));
    }

    public static StepPath fromString(String string) {
        StepPath path = new StepPath();
        for (String part : StringUtils.splitAndTrim(string, '>')) {
            path.getElements().add(Element.fromString(part));
        }
        if (path.getElements().isEmpty() || !path.getElements().get(0).getStepName().equals("master")) {
            throw new QuickbuildException("Invalid step path: " + string);
        }
        return path;
    }

    public List<StepPath> findChildren(List<StepPath> paths) {
        ArrayList<StepPath> children = new ArrayList<StepPath>();
        for (StepPath path : paths) {
            StepPath parent = path.getParent();
            if (parent == null || !parent.equals(this)) continue;
            children.add(path);
        }
        return children;
    }

    public boolean equals(Object other) {
        if (!(other instanceof StepPath)) {
            return false;
        }
        StepPath otherPath = (StepPath)other;
        return this.toString().equals(otherPath.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static class Element
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String stepName;
        private Map<String, String> params = new LinkedHashMap<String, String>();

        public Element(String stepName) {
            this.stepName = stepName;
        }

        public Element(String stepName, Map<String, String> params) {
            this.stepName = stepName;
            this.params = params;
        }

        public String getStepName() {
            return this.stepName;
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        public String toString() {
            if (!this.params.isEmpty()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(this.stepName + "?");
                for (Map.Entry<String, String> entry : this.params.entrySet()) {
                    buffer.append(entry.getKey() + "=" + entry.getValue());
                    buffer.append("&");
                }
                return StringUtils.stripEnd((String)buffer.toString(), (String)"&");
            }
            return this.stepName;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Element)) {
                return false;
            }
            Element otherElement = (Element)other;
            return this.toString().equals(otherElement.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public static Element fromString(String string) {
            if (string.indexOf(63) != -1) {
                String stepName = StringUtils.substringBefore((String)string, (String)"?");
                String paramsString = StringUtils.substringAfter((String)string, (String)"?");
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                for (String each : StringUtils.splitAndTrim(paramsString, "&")) {
                    params.put(StringUtils.substringBefore((String)each, (String)"="), StringUtils.substringAfter((String)each, (String)"="));
                }
                return new Element(stepName, params);
            }
            return new Element(string);
        }
    }
}

