/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.stepsupport;

import com.pmease.quickbuild.BuildAwareTask;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.SecretAwareString;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridJob;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.GridTaskFuture;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.resource.ResourceAllocateTask;
import com.pmease.quickbuild.resource.ResourceAllocation;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.stepsupport.StepExecutionJob;
import com.pmease.quickbuild.stepsupport.StepInfo;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class StepExecutionTask
extends BuildAwareTask<StepPath, Void> {
    public StepExecutionTask(Build build) {
        super(build);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void reduce(Collection<GridJob> results) {
        StepExecutionJob job = (StepExecutionJob)results.iterator().next();
        if (job.getException() != null) {
            throw new RuntimeException("Error executing step execution job.", job.getException());
        }
        Build jobBuild = job.getBuild();
        Build build = this.getBuild();
        BuildRequest buildRequest = build.getRequest();
        synchronized (buildRequest) {
            build.setReports(jobBuild.getReports());
            build.getRepositoryRuntimes().putAll(jobBuild.getRepositoryRuntimes());
            build.getRepositoryCache().putAll(jobBuild.getRepositoryCache());
            for (Repository<?> repository : build.getRepositoryCache().values()) {
                if (repository == null) continue;
                repository.setBuild(build);
            }
            for (Map.Entry entry : jobBuild.getStepRuntimes().entrySet()) {
                StepRuntime originalRuntime = build.getStepRuntimes().get(entry.getKey());
                if (originalRuntime != null && originalRuntime.getStatus() != StepRuntime.Status.IDLE && ((StepRuntime)entry.getValue()).getStatus() == StepRuntime.Status.IDLE) continue;
                build.getStepRuntimes().put((String)entry.getKey(), (StepRuntime)entry.getValue());
            }
            for (Map.Entry entry : jobBuild.getStepCache().entrySet()) {
                Step originalStep = build.getStepCache().get(entry.getKey());
                if (originalStep != null && originalStep.getStatus() != StepRuntime.Status.IDLE && ((Step)entry.getValue()).getStatus() == StepRuntime.Status.IDLE) continue;
                build.getStepCache().put((StepPath)entry.getKey(), (Step)entry.getValue());
            }
            for (Step step : build.getStepCache().values()) {
                if (step == null) continue;
                step.setBuild(build);
            }
            build.getVariables().putAll(jobBuild.getVariables());
            for (Map.Entry entry : jobBuild.getSecretAwareVariableValues().entrySet()) {
                build.getSecretAwareVariableValues().put((String)entry.getKey(), new SecretAwareString((SecretAwareString)entry.getValue()));
            }
        }
        return null;
    }

    @Override
    protected Map<GridJob, GridNode> map(StepPath arg) {
        Step step = this.getBuild().getStep(arg);
        if (step == null) {
            throw new QuickbuildException("Step '" + arg + "' is not found in current build.");
        }
        step.setStatus(StepRuntime.Status.WAITING);
        long time = System.currentTimeMillis();
        StepInfo info = new StepInfo();
        info.setBuildId(this.getBuild().getId());
        info.setVars(this.getBuild().getVariables());
        info.setStepPath(step.getPath());
        GridTaskFuture<ResourceAllocation> taskFuture = Grid.instance.execute(new ResourceAllocateTask(), info);
        ResourceAllocation allocation = taskFuture.get();
        step.setNode(allocation.getNode());
        step.setResources(allocation.getResources());
        this.getBuild().getVariables().putAll(allocation.getVariables());
        step.setWaitDuration(System.currentTimeMillis() - time);
        step.setStatus(StepRuntime.Status.RUNNING);
        HashMap<GridJob, GridNode> map = new HashMap<GridJob, GridNode>();
        map.put(new StepExecutionJob(this.getId(), this.getBuild(), arg), step.getNode());
        return map;
    }
}

