/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.stepsupport;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.stepsupport.StepAwareJob;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import java.util.concurrent.TimeoutException;

public class StepExecutionJob
extends StepAwareJob {
    private static final long serialVersionUID = 1L;

    public StepExecutionJob(String taskId, Build build, StepPath stepPath) {
        super(taskId, build, stepPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeStepAwareJob() {
        FileUtils.createDir(this.getBuild().getConfiguration().getWorkspaceDir());
        long beginTime = System.currentTimeMillis();
        try {
            this.getStep().execute();
        }
        catch (Throwable t) {
            this.getStep().setErrorMessage(this.getBuild().obfuscateSecrets(ExceptionUtils.extractImportantMessage(t)));
            if (ExceptionUtils.extractException(t, InterruptedException.class) != null) {
                this.getStep().setStatus(StepRuntime.Status.CANCELLED);
            } else if (ExceptionUtils.extractException(t, TimeoutException.class) != null) {
                this.getStep().setStatus(StepRuntime.Status.TIMEOUT);
            } else {
                this.getStep().setStatus(StepRuntime.Status.FAILED);
            }
            QuickbuildException qbEx = ExceptionUtils.extractQuickbuildException(t);
            if (qbEx != null) {
                Context.getLogger().error("Step '" + this.getStep().getPath() + "' is failed: " + qbEx.getMessage());
                if (Context.getLogger().isTraceEnabled()) {
                    Context.getLogger().trace("Stack trace for the failure", t);
                }
            } else {
                Context.getLogger().error("Step '" + this.getStep().getPath() + "' is failed.", t);
            }
        }
        finally {
            this.getStep().setDuration(System.currentTimeMillis() - beginTime);
            StepPath stepPath = this.getStep().getPath();
            StepRuntime runtime = this.getStep().getRuntime();
            if (Bootstrap.isServer()) {
                BuildEngine.instance.stepUpdated(Context.getBuild().getId(), stepPath, runtime);
            } else {
                runtime = (StepRuntime)ScriptEngine.instance.uninstallInterpolator(runtime);
                Quickbuild.getServerService().stepUpdated(Context.getBuild().getId(), stepPath, runtime);
            }
        }
    }
}

