/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.stepsupport;

import com.pmease.quickbuild.BuildAwareJob;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.stepsupport.StepPath;

public abstract class StepAwareJob
extends BuildAwareJob {
    private static final long serialVersionUID = 1L;
    private StepPath stepPath;

    public StepAwareJob(String taskId, Build build, StepPath stepPath) {
        super(taskId, build);
        this.stepPath = stepPath;
    }

    public StepAwareJob(String taskId, Build build) {
        this(taskId, build, null);
    }

    public StepPath getStepPath() {
        return this.stepPath;
    }

    public Step getStep() {
        Step step = this.getBuild().getStep(this.stepPath);
        if (step == null) {
            throw new QuickbuildException("Step '" + this.stepPath + "' is not found in current build.");
        }
        return step;
    }

    protected abstract void executeStepAwareJob();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeBuildAwareJob() {
        Context.pushStep(this.getStep());
        this.getStep().setJob(this);
        try {
            this.executeStepAwareJob();
        }
        finally {
            Context.popStep();
        }
    }
}

