/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.stepsupport;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.FileDelivery;
import com.pmease.quickbuild.PromotionSource;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ImplementationProvider;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Name;
import com.pmease.quickbuild.annotation.Numeric;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.extensionpoint.StepProvider;
import com.pmease.quickbuild.extensionpoint.support.TypeInstance;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.log.BuildLogEntry;
import com.pmease.quickbuild.migration.MigrationListener;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ArtifactStorage;
import com.pmease.quickbuild.setting.step.FileTransferOption;
import com.pmease.quickbuild.setting.step.executeaction.ExecuteAction;
import com.pmease.quickbuild.setting.step.executeaction.NoAction;
import com.pmease.quickbuild.setting.step.executecondition.AllPreviousSiblingStepsSuccessful;
import com.pmease.quickbuild.setting.step.executecondition.ExecuteCondition;
import com.pmease.quickbuild.setting.step.nodematcher.MatchResult;
import com.pmease.quickbuild.setting.step.nodematcher.NodeMatcher;
import com.pmease.quickbuild.setting.step.nodematcher.ParentNodeMatcher;
import com.pmease.quickbuild.setting.step.nodepreference.NodePreference;
import com.pmease.quickbuild.setting.step.nodepreference.PreferLeastLoadedNode;
import com.pmease.quickbuild.setting.step.repetition.Repetition;
import com.pmease.quickbuild.stepsupport.CompositeStep;
import com.pmease.quickbuild.stepsupport.FailSafeStep;
import com.pmease.quickbuild.stepsupport.ParallelStep;
import com.pmease.quickbuild.stepsupport.StepAwareJob;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.ServletUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.validation.ErrorContext;
import com.pmease.quickbuild.validation.Validatable;
import com.pmease.quickbuild.variable.VariableWrapper;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.TimeoutException;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.io.IOUtils;
import org.dom4j.Element;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScriptApi
@ImplementationProvider(method="getImplementations")
public abstract class Step
extends TypeInstance
implements Validatable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Step.class);
    public static final String MASTER_NAME = "master";
    public static String[] MASTER_EXCLUDED_PROPERTIES = new String[]{"name", "executeCondition", "repetitions", "inputOption", "outputOption", "enabled", "timeout"};
    private String name;
    private String description;
    private boolean enabled = true;
    private volatile transient String nodeLaunchId;
    private volatile transient Map<String, List<String>> waitReasons;
    private ExecuteCondition executeCondition = new AllPreviousSiblingStepsSuccessful();
    private NodeMatcher nodeMatcher = new ParentNodeMatcher();
    private NodePreference nodePreference = new PreferLeastLoadedNode();
    private FileTransferOption inputOption;
    private FileTransferOption outputOption;
    private String timeout = "0";
    private transient GridNode node;
    private ExecuteAction preExecuteAction = new NoAction();
    private ExecuteAction postExecuteAction = new NoAction();
    private List<Repetition> repetitions = new ArrayList<Repetition>();
    private transient Map<String, VariableWrapper> variableWrappers;
    private StepPath path;
    @XStreamOmitField
    private Build build;
    private transient StepAwareJob job;
    private transient Map<String, Object> legacyResources;

    public abstract void run();

    public String renderLogAsText(BuildLogEntry logEntry, String lineSeparator, boolean showStep) {
        return logEntry.renderAsText(lineSeparator, showStep);
    }

    public String renderLogAsHtml(BuildLogEntry logEntry, boolean showStep) {
        return logEntry.renderAsHtml(showStep);
    }

    @Editable(order=20)
    @NotEmpty
    @Name
    @ScriptApi(value="Get name of the step.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Editable(order=25)
    public String getType() {
        return EditorHelper.getName(this.getClass());
    }

    @Editable(order=30)
    @Multiline
    @ScriptApi(value="Get description of the step.")
    @Scriptable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Editable(order=40)
    @ScriptApi(value="Whether or not this step is enabled.")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Editable(order=50, description="Execute condition determines whether or not to execute this step.")
    @NotNull
    public ExecuteCondition getExecuteCondition() {
        return this.executeCondition;
    }

    public void setExecuteCondition(ExecuteCondition executeCondition) {
        this.executeCondition = executeCondition;
    }

    @Editable(name="Node Selection", order=55, description="Select eligible node to run this step on.")
    @NotNull
    public NodeMatcher getNodeMatcher() {
        return this.nodeMatcher;
    }

    public void setNodeMatcher(NodeMatcher nodeMatcher) {
        this.nodeMatcher = nodeMatcher;
    }

    @Editable(name="Node Preference", order=57, description="Specify which node to prefer to run the step if multiple nodes are matched via node selection setting.")
    @Advanced
    @NotNull
    public NodePreference getNodePreference() {
        return this.nodePreference;
    }

    public void setNodePreference(NodePreference nodePreference) {
        this.nodePreference = nodePreference;
    }

    @Editable(order=60, name="Pre-Execute Action", description="Optionally specify the action to execute before running this step.")
    @NotNull
    @Advanced
    public ExecuteAction getPreExecuteAction() {
        return this.preExecuteAction;
    }

    public void setPreExecuteAction(ExecuteAction preExecuteAction) {
        this.preExecuteAction = preExecuteAction;
    }

    @Editable(name="Post-Execute Action", order=65, description="Optionally specify the action to execute after running this step")
    @NotNull
    @Advanced
    public ExecuteAction getPostExecuteAction() {
        return this.postExecuteAction;
    }

    public void setPostExecuteAction(ExecuteAction postExecuteAction) {
        this.postExecuteAction = postExecuteAction;
    }

    @Editable(name="Repeat Parameters", order=67, description="Step execution will be repeated for each combination of specified parameter values, and <i>params.get(\"parameter name\")</i> can be used to get value of specified parameter for current round of execution. Execution will be repeated parallelly if step is contained in a parallel composition step; otherwise, repetition will be done sequentially.")
    @Advanced
    public List<Repetition> getRepetitions() {
        return this.repetitions;
    }

    public void setRepetitions(List<Repetition> repetitions) {
        this.repetitions = repetitions;
    }

    @Editable(name="Fetch Input Files", order=70, description="Check this if this step requires input files from parent step before exeuction. Input files will be transferred from workspace of the node running parent step to workspace of current node.")
    @Advanced
    public FileTransferOption getInputOption() {
        return this.inputOption;
    }

    public void setInputOption(FileTransferOption inputOption) {
        this.inputOption = inputOption;
    }

    @Editable(name="Send Output Files", order=80, description="Check this if this step wants to send output files to parent step after execution. Output files will be transferred from workspace of current node to workspace of the node running parent parent step.")
    @Advanced
    public FileTransferOption getOutputOption() {
        return this.outputOption;
    }

    public void setOutputOption(FileTransferOption outputOption) {
        this.outputOption = outputOption;
    }

    @Editable(order=90, description="Specify timeout in seconds for execution of this step. QuickBuild will try to cancel the step if step execution time exceeds the timeout value. Use <tt>0</tt> to disable step time out.")
    @Numeric
    @NotEmpty
    @Range(min=0L, max=43200L)
    @Scriptable
    @Advanced
    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    @ScriptApi(value="Get parent composite step containing this step. Null if this step is not contained in a composite step. This method should only be called from background build thread.")
    public CompositeStep getParent() {
        Validate.isTrue((boolean)Context.isBackend());
        StepPath parentPath = this.path.getParent();
        if (parentPath != null) {
            CompositeStep parent = (CompositeStep)Context.getBuild().getStep(parentPath);
            if (parent == null) {
                throw new QuickbuildException("Can not find step with path: " + parentPath);
            }
            return parent;
        }
        return null;
    }

    @ScriptApi(value="Is this step the master step?")
    public boolean isMaster() {
        return this.getName().equals(MASTER_NAME);
    }

    @ScriptApi(value="Get the step defined before this step if this step is contained in a sequential step. Null if this is the first step or if it is contained in a parallel composite step.")
    public Step getPreviousSibling() {
        CompositeStep parentStep = this.getParent();
        if (parentStep == null) {
            return null;
        }
        if (parentStep instanceof ParallelStep) {
            return null;
        }
        List<Step> children = parentStep.getChildren();
        Collections.reverse(children);
        boolean after = false;
        for (Step child : children) {
            if (child.getPath().equals(this.getPath())) {
                after = true;
                continue;
            }
            if (!after) continue;
            return child;
        }
        return null;
    }

    @ScriptApi(value="Get the step executed before this step if this step is contained in a sequential step. Null if there is no executed step before this step or if this step is contained in a parallel composition step.")
    public Step getPreviousExecutedSibling() {
        CompositeStep parentStep = this.getParent();
        if (parentStep == null) {
            return null;
        }
        if (parentStep instanceof ParallelStep) {
            return null;
        }
        List<Step> children = parentStep.getChildren();
        Collections.reverse(children);
        boolean after = false;
        for (Step child : children) {
            if (child.getPath().equals(this.getPath())) {
                after = true;
                continue;
            }
            if (!after || child.getStatus() == StepRuntime.Status.IDLE) continue;
            return child;
        }
        return null;
    }

    @ScriptApi(value="Get status of this step.")
    public StepRuntime.Status getStatus() {
        return this.getRuntime().getStatus();
    }

    public void setStatus(StepRuntime.Status status) {
        this.getRuntime().setStatus(status);
    }

    @ScriptApi(value="Get duration of this step in milliseconds. Null if unknown.")
    public Long getDuration() {
        return this.getRuntime().getDuration();
    }

    public void setDuration(Long duration) {
        this.getRuntime().setDuration(duration);
    }

    @ScriptApi(value="Get wait duration of this step in milliseconds. Null if unknown.")
    public Long getWaitDuration() {
        return this.getRuntime().getWaitDuration();
    }

    public void setWaitDuration(Long waitDuration) {
        this.getRuntime().setWaitDuration(waitDuration);
    }

    @ScriptApi(value="Get error message of this step. Null if no error.")
    public String getErrorMessage() {
        return this.getRuntime().getErrorMessage();
    }

    public void setErrorMessage(String errorMessage) {
        this.getRuntime().setErrorMessage(errorMessage);
    }

    @ScriptApi(value="Whether or not this step is successful.")
    public boolean isSuccessful() {
        return this.getStatus() == StepRuntime.Status.SUCCESSFUL;
    }

    @ScriptApi(value="Whether or not this step is failed.")
    public boolean isFailed() {
        return this.getStatus() == StepRuntime.Status.FAILED || this.getStatus() == StepRuntime.Status.TIMEOUT;
    }

    @ScriptApi(value="Whether or not this step is idle.")
    public boolean isIdle() {
        return this.getStatus() == StepRuntime.Status.IDLE;
    }

    @ScriptApi(value="Whether or not this step is running.")
    public boolean isRunning() {
        return this.getStatus() == StepRuntime.Status.RUNNING;
    }

    @ScriptApi(value="Whether or not this step is finished.")
    public boolean isFinished() {
        return this.isSuccessful() || this.isFailed();
    }

    @ScriptApi(value="Whether or not this step is cancelled.")
    public boolean isCancelled() {
        return this.getStatus() == StepRuntime.Status.CANCELLED;
    }

    @ScriptApi(value="Whether or not this step is timeout.")
    public boolean isTimeout() {
        return this.getStatus() == StepRuntime.Status.TIMEOUT;
    }

    @ScriptApi(value="Whetheror not this step is waiting.")
    public boolean isWaiting() {
        return this.getStatus() == StepRuntime.Status.WAITING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() {
        if (this.getPreExecuteAction() != null) {
            Context.getLogger().info("Executing pre-execute action...");
            this.getPreExecuteAction().execute(this);
        }
        try {
            if (this.isMaster()) {
                PromotionSource promotionSource = Context.getBuild().getRequest().getPromotionSource();
                if (promotionSource != null) {
                    for (Repository<?> repository : this.getBuild().getRepositories()) {
                        if (!repository.isCheckout() || !Context.getConfiguration().isRecordSCMChanges()) continue;
                        repository.getChanges();
                    }
                    for (FileDelivery delivery : promotionSource.getDeliveries()) {
                        File destDir = delivery.getDestPath() != null ? new File(Context.getConfiguration().getWorkspaceDir(), delivery.getDestPath()) : Context.getConfiguration().getWorkspaceDir();
                        if (promotionSource.getServer() != null) {
                            InputStream is = null;
                            try {
                                String content = "build_id=" + promotionSource.getBuildId() + "&" + "src_path" + "=" + URLEncoder.encode(delivery.getSrcPath(), "UTF-8") + "&" + "file_patterns" + "=" + URLEncoder.encode(delivery.getFilePatterns(), "UTF-8");
                                is = ServletUtils.download(promotionSource.getServer().getUrl() + "/batch_download" + "?" + content, promotionSource.getServer().getUserName(), promotionSource.getServer().getPassword());
                                FileUtils.unzip(is, destDir);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(is);
                                throw throwable;
                            }
                            IOUtils.closeQuietly((Closeable)is);
                            continue;
                        }
                        Build sourceBuild = (Build)BuildManager.instance.load(promotionSource.getBuildId());
                        ArtifactStorage artifactStorage = sourceBuild.getConfiguration().findArtifactStorage();
                        if (artifactStorage.getBatchSupport() != null) {
                            artifactStorage.getBatchSupport().download(sourceBuild, delivery.getSrcPath(), delivery.getFilePatterns(), destDir);
                            continue;
                        }
                        for (String each : Quickbuild.getServerService().listArtifacts(sourceBuild.getId(), delivery.getSrcPath(), delivery.getFilePatterns())) {
                            artifactStorage.download(sourceBuild, each, new File(destDir, each));
                        }
                    }
                }
                for (Repository<?> repository : this.build.getRepositories()) {
                    if (!repository.isCheckout() || !Context.getConfiguration().isRecordSCMChanges()) continue;
                    Quickbuild.getServerService().writeChanges(this.build.getId(), repository.getName(), repository.getChanges());
                    repository.setChangesRecorded(true);
                }
            }
            if (this.getInputOption() != null) {
                Context.getLogger().info("Fetching input files...");
                this.job.fetchInputFiles(this.getInputOption());
            }
            Context.getLogger().info("Running step...");
            this.run();
            this.setStatus(StepRuntime.Status.SUCCESSFUL);
        }
        catch (Throwable e) {
            this.setErrorMessage(this.getBuild().obfuscateSecrets(ExceptionUtils.extractImportantMessage(e)));
            if (ExceptionUtils.extractException(e, InterruptedException.class) != null) {
                this.setStatus(StepRuntime.Status.CANCELLED);
            } else if (ExceptionUtils.extractException(e, TimeoutException.class) != null) {
                this.setStatus(StepRuntime.Status.TIMEOUT);
            } else {
                this.setStatus(StepRuntime.Status.FAILED);
            }
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
        finally {
            try {
                if (this.getOutputOption() != null && (this.isSuccessful() || this.getOutputOption().isTransferIfFailed())) {
                    Context.getLogger().info("Sending output files...");
                    this.job.sendOutputFiles(this.getOutputOption());
                }
            }
            finally {
                if (this.getPostExecuteAction() != null) {
                    Context.getLogger().info("Executing post-execute action...");
                    this.getPostExecuteAction().execute(this);
                }
            }
        }
    }

    public CompositeStep findParent(String name) {
        for (CompositeStep parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.getName().equals(name)) continue;
            return parent;
        }
        return null;
    }

    @Override
    public void validate(Set<String> properties, ErrorContext errorContext) {
        if (properties.contains("name") && errorContext.getError("name") == null && this.getName().indexOf(44) != -1) {
            errorContext.setError("name", "Character ',' is not allowed here.");
        }
    }

    @ScriptApi(value="Get the node running current step. Null if the step is not allocated to a node.")
    public GridNode getNode() {
        if (this.node == null && this.getNodeAddress() != null) {
            this.node = Grid.instance.getNode(this.getNodeAddress());
            if (this.node == null) {
                throw new QuickbuildException("Unable to find node '" + this.getNodeAddress() + "'.");
            }
        }
        return this.node;
    }

    public void setNode(GridNode node) {
        this.node = node;
        this.getRuntime().setNodeAddress(node.getAddress());
    }

    @ScriptApi(value="Get address of the node running this step.")
    public String getNodeAddress() {
        return this.getRuntime().getNodeAddress();
    }

    @ScriptApi(value="Get resources allocated to this step.")
    public Map<String, Integer> getResources() {
        return this.getRuntime().getResources();
    }

    public void setResources(Map<String, Integer> resources) {
        this.getRuntime().setResources(new HashMap<String, Integer>(resources));
    }

    protected void setJob(StepAwareJob job) {
        this.job = job;
    }

    public StepRuntime getRuntime() {
        StepRuntime runtime = this.getBuild().getStepRuntimes().get(this.getPath().toString());
        if (runtime == null) {
            runtime = new StepRuntime();
            this.getBuild().getStepRuntimes().put(this.getPath().toString(), runtime);
        }
        return runtime;
    }

    @ScriptApi(value="Get path of this step.")
    public StepPath getPath() {
        if (this.path == null) {
            throw new QuickbuildException("This method can only be called against step object returned by a build.");
        }
        return this.path;
    }

    public void setPath(StepPath path) {
        this.path = path;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Step)) {
            return false;
        }
        Step otherStep = (Step)other;
        return new EqualsBuilder().append((Object)this.getName(), (Object)otherStep.getName()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getName()).toHashCode();
    }

    public static Step fromDOM(final Configuration configuration, VersionedDocument dom) {
        try {
            return (Step)dom.toBean(new MigrationListener(){

                @Override
                public void afterMigration(Object bean) {
                    Step step = (Step)bean;
                    ConfigurationManager.instance.saveStep(configuration.getId(), step);
                }
            });
        }
        catch (Exception e) {
            if (RequestCycle.get() != null) {
                logger.error("Error constructing step from DOM.", (Throwable)e);
                FailSafeStep step = new FailSafeStep();
                step.setName(dom.getValue("name"));
                step.setDescription(e.getClass().getSimpleName() + ":" + e.getMessage());
                return step;
            }
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }

    private Map<String, Object> getLegacyResources() {
        if (this.legacyResources == null) {
            this.legacyResources = new HashMap<String, Object>();
        }
        return this.legacyResources;
    }

    @ScriptApi(value="Get step resource of specified name. Null will returned if resource of the name is not found.")
    public synchronized Object getResource(String name) {
        return this.getLegacyResources().get(name);
    }

    @ScriptApi(value="Set step resource. The first param represents name of the resource, and the second param represents the resource itself.")
    public synchronized void setResource(String name, Object resource) {
        this.getLegacyResources().put(name, resource);
    }

    @ScriptApi(value="Get step resource of specified name (the first param). If resource is not found, the specified default resource (the second param) will be associated with the name.")
    public synchronized Object getResource(String name, Object defaultResource) {
        Object resource = this.getLegacyResources().get(name);
        if (resource == null) {
            this.getLegacyResources().put(name, defaultResource);
            return defaultResource;
        }
        return resource;
    }

    @ScriptApi(value="Remove specified step resource.")
    public synchronized void removeResource(String name) {
        this.getLegacyResources().remove(name);
    }

    @ScriptApi(value="Clear all step resources.")
    public synchronized void clearResources() {
        this.getLegacyResources().clear();
    }

    private static Collection<Class<?>> getImplementations() {
        HashSet implementations = new HashSet();
        for (StepProvider provider : PluginManager.instance.getExtensions(StepProvider.class)) {
            Class<? extends Step> stepClass = provider.getStepClass();
            if (stepClass == null) continue;
            implementations.add(stepClass);
        }
        return implementations;
    }

    public boolean shouldExecute() {
        return this.isEnabled() && this.getExecuteCondition().satisfied(this);
    }

    public MatchResult matches(GridNode node) {
        return this.getNodeMatcher().matches(this, node);
    }

    @ScriptApi(value="Get value of specified parameter for current iteration. Null if not found.")
    public String getParam(String paramName) {
        ArrayList<StepPath.Element> elements = new ArrayList<StepPath.Element>();
        elements.addAll(this.getPath().getElements());
        Collections.reverse(elements);
        for (StepPath.Element each : elements) {
            String value = each.getParams().get(paramName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public Component renderCustomRuntimeData(String panelId, Object customRuntimeData) {
        return new WebMarkupContainer(panelId);
    }

    public String toString() {
        return this.getName();
    }

    @ScriptApi(value="Get build object associated with this step. Return null if no build is associated.")
    public Build getBuild() {
        if (this.build == null) {
            throw new QuickbuildException("The step is not associated with any build.");
        }
        return this.build;
    }

    public void setBuild(Build build) {
        this.build = build;
    }

    public String getNodeLaunchId() {
        return this.nodeLaunchId;
    }

    public void setNodeLaunchId(String nodeLaunchId) {
        this.nodeLaunchId = nodeLaunchId;
    }

    public Map<String, List<String>> getWaitReasons() {
        return this.waitReasons;
    }

    public void setWaitReasons(Map<String, List<String>> waitReasons) {
        this.waitReasons = waitReasons;
    }

    public Map<String, VariableWrapper> getVariableWrappers() {
        return this.variableWrappers;
    }

    public void setVariableWrappers(Map<String, VariableWrapper> variableWrappers) {
        this.variableWrappers = variableWrappers;
    }

    protected List<Property> getActualEnvironments(List<Property> environments) {
        HashMap<String, String> environmentMap = new HashMap<String, String>();
        for (Property each : environments) {
            environmentMap.put(each.getName(), each.getValue());
        }
        for (CompositeStep parentStep = this.getParent(); parentStep != null; parentStep = parentStep.getParent()) {
            for (Property each : parentStep.getEnvironments()) {
                if (environmentMap.containsKey(each.getName())) continue;
                environmentMap.put(each.getName(), each.getValue());
            }
        }
        ArrayList<Property> actualEnvironments = new ArrayList<Property>();
        for (Map.Entry entry : environmentMap.entrySet()) {
            actualEnvironments.add(new Property((String)entry.getKey(), (String)entry.getValue()));
        }
        return actualEnvironments;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        String nodeMatchCondition = dom.getValue("nodeMatchCondition");
        nodeMatchCondition = StringUtils.replace((String)nodeMatchCondition, (String)"isAgent()", (String)"isBuildAgent()");
        dom.setValue("nodeMatchCondition", nodeMatchCondition);
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        String workspaceCleanupCondition = dom.getValue("workspaceCleanupCondition");
        if (!workspaceCleanupCondition.equals("false")) {
            if (workspaceCleanupCondition.equals("true")) {
                dom.getRootElement().addElement("preExecuteScript").setText("util.cleanDir(configuration.workspaceDir)");
            } else {
                dom.getRootElement().addElement("preExecuteScript").setText("if (" + workspaceCleanupCondition + ")\n " + "  util.cleanDir(configuration.workspaceDir);");
            }
        }
        dom.getRootElement().element("workspaceCleanupCondition").detach();
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        Element outputFilesElement;
        Element inputFilesElement = dom.getRootElement().element("inputFilePatterns");
        if (inputFilesElement != null) {
            Element inputOptionElement = dom.getRootElement().addElement("inputOption");
            inputOptionElement.addElement("filePatterns").setText(inputFilesElement.getText());
            inputOptionElement.addElement("compress").setText("true");
            inputFilesElement.detach();
        }
        if ((outputFilesElement = dom.getRootElement().element("outputFilePatterns")) != null) {
            Element outputOptionElement = dom.getRootElement().addElement("outputOption");
            outputOptionElement.addElement("filePatterns").setText(outputFilesElement.getText());
            outputOptionElement.addElement("compress").setText("true");
            outputFilesElement.detach();
        }
    }

    private void migrate4(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().element("status").detach();
    }

    private void migrate5(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("repetitions");
        Element executeConditionElement = dom.getRootElement().element("executeCondition");
        String executeCondition = executeConditionElement.getText().trim();
        executeConditionElement.clearContent();
        if (executeCondition.equals("current.parent==null || !current.parent.anyChildFailed")) {
            executeConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.executecondition.AllPreviousSiblingStepsSuccessful");
        } else if (executeCondition.equals("current.parent!=null && current.parent.anyChildFailed")) {
            executeConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.executecondition.AnyPreviousSiblingStepFailed");
        } else if (executeCondition.equals("true")) {
            executeConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.executecondition.AlwaysExecute");
        } else if (executeCondition.equals("false")) {
            executeConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.executecondition.NeverExecute");
        } else {
            executeConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.executecondition.ScriptExecuteCondition").addElement("script").setText(executeCondition);
        }
        Element nodeMatchConditionElement = dom.getRootElement().element("nodeMatchCondition");
        nodeMatchConditionElement.setName("nodeMatcher");
        String nodeMatchCondition = nodeMatchConditionElement.getText().trim();
        nodeMatchConditionElement.clearContent();
        if (nodeMatchCondition.equals("current.parent==null?node.isServer():node==current.parent.node")) {
            nodeMatchConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.nodematcher.ParentNodeMatcher");
        } else if (nodeMatchCondition.equals("node==current.previousExecuted.node")) {
            nodeMatchConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.nodematcher.PreviousNodeMatcher");
        } else if (nodeMatchCondition.equals("true")) {
            nodeMatchConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.nodematcher.AnyNodeMatcher");
        } else if (nodeMatchCondition.equals("node.isServer()")) {
            nodeMatchConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.nodematcher.ServerNodeMatcher");
        } else if (nodeMatchCondition.equals("node.isBuildAgent()")) {
            nodeMatchConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.nodematcher.AnyBuildAgentMatcher");
        } else if (nodeMatchCondition.equals("node.isUserAgent()")) {
            nodeMatchConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.nodematcher.UserAgentMatcher");
        } else {
            nodeMatchConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.nodematcher.ScriptNodeMatcher").addElement("script").setText(nodeMatchCondition);
        }
        Element preExecuteScriptElement = dom.getRootElement().element("preExecuteScript");
        if (preExecuteScriptElement != null) {
            preExecuteScriptElement.setName("preExecuteAction");
            String preExecuteScript = preExecuteScriptElement.getText().trim();
            preExecuteScriptElement.clearContent();
            if (preExecuteScript.equals("util.cleanDir(configuration.workspaceDir);")) {
                preExecuteScriptElement.addAttribute("class", "com.pmease.quickbuild.setting.step.executeaction.CleanWorkspace");
            } else {
                preExecuteScriptElement.addAttribute("class", "com.pmease.quickbuild.setting.step.executeaction.ScriptExecuteAction").addElement("script").setText(preExecuteScript);
            }
        } else {
            dom.getRootElement().addElement("preExecuteAction").addAttribute("class", "com.pmease.quickbuild.setting.step.executeaction.NoAction");
        }
        Element postExecuteScriptElement = dom.getRootElement().element("postExecuteScript");
        if (postExecuteScriptElement != null) {
            postExecuteScriptElement.setName("postExecuteAction");
            String postExecuteScript = postExecuteScriptElement.getText().trim();
            postExecuteScriptElement.clearContent();
            if (postExecuteScript.equals("util.cleanDir(configuration.workspaceDir);")) {
                postExecuteScriptElement.addAttribute("class", "com.pmease.quickbuild.setting.step.executeaction.CleanWorkspace");
            } else {
                postExecuteScriptElement.addAttribute("class", "com.pmease.quickbuild.setting.step.executeaction.ScriptExecuteAction").addElement("script").setText(postExecuteScript);
            }
        } else {
            dom.getRootElement().addElement("postExecuteAction").addAttribute("class", "com.pmease.quickbuild.setting.step.executeaction.NoAction");
        }
    }

    private void migrate6(VersionedDocument dom, Stack<Integer> versions) {
        List repetitionElements = dom.getRootElement().element("repetitions").elements();
        for (Element repetitionElement : repetitionElements) {
            String attribute;
            Element attributeElement;
            Element nodeFilterElement;
            Element paramValuesElement = repetitionElement.element("paramValues");
            String classAttr = paramValuesElement.attributeValue("class");
            if (classAttr.contains("AllBuildAgents")) {
                paramValuesElement.addAttribute("class", "com.pmease.quickbuild.setting.step.repetition.FilteredNodes");
                nodeFilterElement = paramValuesElement.addElement("nodeFilter");
                nodeFilterElement.addAttribute("class", "com.pmease.quickbuild.setting.step.repetition.nodefilter.AnyBuildAgentFilter");
                continue;
            }
            if (classAttr.contains("AllNodes")) {
                paramValuesElement.addAttribute("class", "com.pmease.quickbuild.setting.step.repetition.FilteredNodes");
                nodeFilterElement = paramValuesElement.addElement("nodeFilter");
                nodeFilterElement.addAttribute("class", "com.pmease.quickbuild.setting.step.repetition.nodefilter.AnyNodeFilter");
                continue;
            }
            if (classAttr.contains("HasAttributeNodes")) {
                attributeElement = paramValuesElement.element("attribute");
                attribute = attributeElement.getTextTrim();
                attributeElement.detach();
                paramValuesElement.addAttribute("class", "com.pmease.quickbuild.setting.step.repetition.FilteredNodes");
                Element nodeFilterElement2 = paramValuesElement.addElement("nodeFilter");
                nodeFilterElement2.addAttribute("class", "com.pmease.quickbuild.setting.step.repetition.nodefilter.HasAttributeFilter");
                nodeFilterElement2.addElement("attribute").setText(attribute);
                continue;
            }
            if (!classAttr.contains("HasAttributeValueNodes")) continue;
            attributeElement = paramValuesElement.element("attribute");
            attribute = attributeElement.getTextTrim();
            attributeElement.detach();
            Element operatorElement = paramValuesElement.element("operator");
            operatorElement.detach();
            String operator = operatorElement.getTextTrim();
            Element valueElement = paramValuesElement.element("value");
            String value = valueElement.getTextTrim();
            valueElement.detach();
            paramValuesElement.addAttribute("class", "com.pmease.quickbuild.setting.step.repetition.FilteredNodes");
            Element nodeFilterElement3 = paramValuesElement.addElement("nodeFilter");
            nodeFilterElement3.addAttribute("class", "com.pmease.quickbuild.setting.step.repetition.nodefilter.HashAttributeValueFilter");
            nodeFilterElement3.addElement("attribute").setText(attribute);
            nodeFilterElement3.addElement("operator").setText(operator);
            nodeFilterElement3.addElement("value").setText(value);
        }
    }

    private void migrate7(VersionedDocument dom, Stack<Integer> versions) {
        Element executeConditionElement = dom.getRootElement().element("executeCondition");
        if (executeConditionElement.attributeValue("class").equals("com.pmease.quickbuild.setting.step.executecondition.NeverExecute")) {
            executeConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.executecondition.AlwaysExecute");
            dom.getRootElement().addElement("enabled").setText("false");
        } else {
            dom.getRootElement().addElement("enabled").setText("true");
        }
    }

    private void migrate8(VersionedDocument dom, Stack<Integer> versions) {
        Element executeConditionElement = dom.getRootElement().element("executeCondition");
        if (executeConditionElement.attributeValue("class").equals("com.pmease.quickbuild.setting.step.executecondition.NeverExecute")) {
            executeConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.executecondition.AlwaysExecute");
            if (dom.getRootElement().element("enabled") == null) {
                dom.getRootElement().addElement("enabled").setText("false");
            }
        } else if (dom.getRootElement().element("enabled") == null) {
            dom.getRootElement().addElement("enabled").setText("true");
        }
    }

    private void migrate9(VersionedDocument dom, Stack<Integer> versions) {
        Element preExecutionActionElement = dom.getRootElement().element("preExecuteAction");
        if (preExecutionActionElement.attributeValue("class").equals("com.pmease.quickbuild.setting.step.executeaction.CancelSiblingsIfFailed")) {
            preExecutionActionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.executeaction.NoAction");
        }
        Element postExecutionActionElement = dom.getRootElement().element("postExecuteAction");
        if (preExecutionActionElement.attributeValue("class").equals("com.pmease.quickbuild.setting.step.executeaction.CancelSiblingsIfFailed")) {
            preExecutionActionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.executeaction.NoAction");
        }
    }

    private void migrate10(VersionedDocument dom, Stack<Integer> versions) {
        Element outputOptionElement = dom.getRootElement().element("outputOption");
        if (outputOptionElement != null) {
            outputOptionElement.addElement("transferIfFailed").setText("false");
        }
    }

    private void migrate11(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("nodePreference").addAttribute("class", "com.pmease.quickbuild.setting.step.nodepreference.PreferLeastLoadedNode");
    }

    private void migrate12(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("timeout").setText("0");
    }
}

