/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.stepsupport;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridTaskFuture;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.stepsupport.CompositeStep;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.stepsupport.StepProcessTask;
import com.pmease.quickbuild.util.EasySet;
import java.util.List;
import java.util.Stack;

@Editable(name="Sequential", description="A composite step to trigger child steps sequentially.", category={"Composition"})
@ScriptApi
public class SequentialStep
extends CompositeStep {
    private static final long serialVersionUID = 1L;

    @Override
    public final void triggerChildren() {
        List<Step> children = this.findChildren();
        for (Step childStep : children) {
            GridTaskFuture<Void> taskFuture = Grid.instance.execute(new StepProcessTask(Context.getBuild()), EasySet.create(childStep.getPath()));
            taskFuture.get();
        }
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().element("listOfStepNames").setName("childStepNames");
    }
}

