/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.stepsupport;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.stepsupport.Step;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@ScriptApi(value="Base class for repository operation steps.")
public abstract class RepositoryStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String repositoryName;

    @ScriptApi(value="Get repository name.")
    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    private static List<String> getAvailableRepositoryNames() {
        ArrayList<String> available = new ArrayList<String>(Context.getConfiguration().findRepositoryNames());
        Collections.sort(available);
        return available;
    }

    @ScriptApi(value="Get repository object referenced by this step.")
    public Repository<?> getRepository() {
        if (this.getRepositoryName() == null) {
            throw new QuickbuildException("No repository referenced in step '" + this.getName() + "'.");
        }
        Repository<?> repository = Context.get().getRepository(this.getRepositoryName());
        if (repository == null) {
            throw new QuickbuildException("Can not find repository '" + this.getRepositoryName() + "' in step '" + this.getName() + "'.");
        }
        return repository;
    }
}

