/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.stepsupport;

import com.google.common.base.Preconditions;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridJob;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.GridTaskFuture;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.stepsupport.CompositeStep;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.stepsupport.StepProcessJob;
import com.pmease.quickbuild.stepsupport.StepProcessTask;
import java.util.ArrayList;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.Basic;

@Editable(name="Parallel", category={"Composition"}, description="A composite step to trigger child steps parallelly.")
@ScriptApi
public class ParallelStep
extends CompositeStep {
    private static final long serialVersionUID = 1L;
    private boolean cancelOnError;

    @Override
    public final void triggerChildren() {
        ArrayList<StepPath> stepPaths = new ArrayList<StepPath>();
        for (Step each : this.findChildren()) {
            stepPaths.add(each.getPath());
        }
        final AtomicReference<Object> taskFutureRef = new AtomicReference<Object>(null);
        final Thread thread = Thread.currentThread();
        if (!stepPaths.isEmpty()) {
            StepProcessTask task = new StepProcessTask(Context.getBuild()){

                @Override
                public void jobFinished(GridJob job, GridNode node) {
                    super.jobFinished(job, node);
                    if (ParallelStep.this.cancelOnError) {
                        GridTaskFuture taskFuture = (GridTaskFuture)taskFutureRef.get();
                        Preconditions.checkNotNull((Object)taskFuture);
                        taskFuture.markHardCancel();
                        if (job.getException() != null) {
                            thread.interrupt();
                        } else {
                            StepProcessJob stepProcessJob = (StepProcessJob)job;
                            if (!stepProcessJob.getStep().isSuccessful()) {
                                thread.interrupt();
                            }
                        }
                    }
                }
            };
            taskFutureRef.set(Grid.instance.execute(task, stepPaths));
            ((GridTaskFuture)taskFutureRef.get()).get();
        }
    }

    @Editable(order=1010, description="Cancel other running child steps if one step is failed.")
    @Basic
    public boolean isCancelOnError() {
        return this.cancelOnError;
    }

    public void setCancelOnError(boolean cancelOnError) {
        this.cancelOnError = cancelOnError;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().element("setOfStepNames").setName("childStepNames");
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("cancelOnError").setText("false");
    }
}

