/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.stepsupport;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.setting.step.repetition.Repetition;
import com.pmease.quickbuild.setting.step.successcondition.AllChildStepsSuccessful;
import com.pmease.quickbuild.setting.step.successcondition.SuccessCondition;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.stepsupport.StepVisitor;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.setting.StepEdit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.wicket.Component;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.dom4j.Element;

@ScriptApi
public abstract class CompositeStep
extends Step {
    private static final long serialVersionUID = 1L;
    private List<String> childStepNames = new ArrayList<String>();
    private SuccessCondition successCondition = new AllChildStepsSuccessful();
    private List<Property> environments = new ArrayList<Property>();

    @Editable(name="Child steps", order=1000, description="Choose child steps to trigger.")
    @ChoiceProvider(value="getAvailableStepNames")
    @ScriptApi(value="Get child step names.")
    public List<String> getChildStepNames() {
        return this.childStepNames;
    }

    public void setChildStepNames(List<String> childStepNames) {
        this.childStepNames = childStepNames;
    }

    private static List<String> getAvailableStepNames() {
        Set<String> availableStepNames = Context.getConfiguration().findStepNames();
        ArrayList<String> stepNames = new ArrayList<String>(availableStepNames);
        Validate.notNull((Object)((Object)BasePage.get()));
        StepEdit editor = (StepEdit)((Object)BasePage.get().visitChildren(StepEdit.class, (IVisitor)new IVisitor<Component, Component>(){

            public void component(Component object, IVisit<Component> visit) {
                visit.stop((Object)object);
            }
        }));
        if (editor.getStepName() != null) {
            stepNames.remove(editor.getStepName());
        }
        Collections.sort(stepNames);
        return stepNames;
    }

    @Editable(order=2000, description="This composite step is considered to be successful if the success condition is satisfied.")
    @NotNull
    public SuccessCondition getSuccessCondition() {
        return this.successCondition;
    }

    public void setSuccessCondition(SuccessCondition successCondition) {
        this.successCondition = successCondition;
    }

    @Editable(name="Environment Variables", description="Optionally specify environment variables for this container. Container will be inherited by and can be overriden by child steps in this container, and they will eventually be used by various steps calling external commands, such as ant build step, command build step, etc.")
    @ScriptApi(value="Get defined environment variables when executing the build command.")
    @Advanced
    public List<Property> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<Property> environments) {
        this.environments = environments;
    }

    @Override
    public final void run() {
        this.triggerChildren();
        for (Step step : this.getChildren()) {
            if (!step.isCancelled()) continue;
            throw new RuntimeException(new InterruptedException("Composite step '" + this.getName() + "' is cancelled."));
        }
        if (!this.getSuccessCondition().satisfied(this)) {
            throw new QuickbuildException("Composite step '" + this.getName() + "' failed due to unsatisfied success condition.");
        }
    }

    @ScriptApi(value="Get children of this step.")
    public List<Step> getChildren() {
        Validate.notNull((Object)this.getBuild());
        ArrayList<Step> children = new ArrayList<Step>();
        ArrayList<StepPath> paths = new ArrayList<StepPath>();
        for (Step step : this.getBuild().getSteps()) {
            paths.add(step.getPath());
        }
        for (StepPath childPath : this.getPath().findChildren(paths)) {
            Step childStep = this.getBuild().getStep(childPath);
            Validate.notNull((Object)childStep);
            children.add(childStep);
        }
        return children;
    }

    protected List<Step> findChildren() {
        ScriptEngine scriptEngine = Quickbuild.getInstance(ScriptEngine.class);
        ArrayList<Step> children = new ArrayList<Step>();
        for (String childName : this.getChildStepNames()) {
            Step childStep = Context.getConfiguration().findStep(childName);
            if (childStep == null) {
                throw new QuickbuildException("Step '" + childName + "' is not found in current build.");
            }
            childStep = (Step)scriptEngine.installInterpolator(childStep);
            List<Repetition> repetitions = childStep.getRepetitions();
            Stack<Map<Object, Object>> stack = new Stack<Map<Object, Object>>();
            Map<String, String> params = new LinkedHashMap();
            stack.push(params);
            while (!stack.isEmpty()) {
                params = (Map)stack.pop();
                if (params.size() == repetitions.size()) {
                    StepPath childPath = new StepPath();
                    childPath.getElements().addAll(this.getPath().getElements());
                    Iterator it = params.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        if (entry.getValue() != null) continue;
                        it.remove();
                    }
                    childPath.getElements().add(new StepPath.Element(childName, params));
                    childStep = Context.get().getStep(childPath);
                    Validate.notNull((Object)childStep);
                    children.add(childStep);
                    continue;
                }
                Repetition repetition = repetitions.get(params.size());
                ArrayList<String> values = new ArrayList<String>();
                for (String each : repetition.getParamValues().get(this)) {
                    if (!StringUtils.isNotBlank((String)each)) continue;
                    if (StringUtils.containsAny((String)each, (String)">?&=#")) {
                        throw new QuickbuildException("Character \">?&=#\" can not be contained in parameter values.");
                    }
                    String value = each = each.trim();
                    int index = 2;
                    while (values.contains(value)) {
                        value = each + "#" + index++;
                    }
                    values.add(value);
                }
                if (values.isEmpty()) continue;
                Collections.reverse(values);
                for (String value : values) {
                    params = new LinkedHashMap<String, String>(params);
                    params.put(repetition.getParamName(), value);
                    stack.push(params);
                }
            }
        }
        return children;
    }

    @ScriptApi(value="Get child step of specified name. For repeatible step, step name needs to be suffixed with repeat params, for example: <i>test?db=oracle&platform=win32</i>. Null will be returned if child step is not found.")
    public Step getChild(String stepName) {
        for (Step child : this.getChildren()) {
            if (!child.getPath().getLastElement().toString().equals(stepName)) continue;
            return child;
        }
        return null;
    }

    protected abstract void triggerChildren();

    @ScriptApi(value="Check if there is any successful child step.")
    public boolean isAnyChildSuccessful() {
        boolean isAnyChildSuccessful = false;
        for (Step child : this.getChildren()) {
            if (child.getStatus() != StepRuntime.Status.SUCCESSFUL) continue;
            isAnyChildSuccessful = true;
            break;
        }
        return isAnyChildSuccessful;
    }

    @ScriptApi(value="Check if there is any failed child step.")
    public boolean isAnyChildFailed() {
        boolean isAnyChildFailed = false;
        for (Step child : this.getChildren()) {
            if (!child.isFailed()) continue;
            isAnyChildFailed = true;
            break;
        }
        return isAnyChildFailed;
    }

    @ScriptApi(value="Check if there is any cancelled child step.")
    public boolean isAnyChildCancelled() {
        boolean isAnyChildCancelled = false;
        for (Step child : this.getChildren()) {
            if (!child.isCancelled()) continue;
            isAnyChildCancelled = true;
            break;
        }
        return isAnyChildCancelled;
    }

    public Step visitChildren(StepVisitor visitor) {
        Validate.isTrue((boolean)Context.isBackend());
        List<Step> children = this.getChildren();
        for (Step step : children) {
            Step found = visitor.visit(step);
            if (found != null) {
                return found;
            }
            if (!(step instanceof CompositeStep)) continue;
            ((CompositeStep)step).visitChildren(visitor);
        }
        return null;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element successConditionElement = dom.getRootElement().element("successCondition");
        String successCondition = successConditionElement.getText().trim();
        successConditionElement.clearContent();
        if (successCondition.equals("!current.anyChildFailed")) {
            successConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.successcondition.AllChildStepsSuccessful");
        } else if (successCondition.equals("current.anyChildSuccessful")) {
            successConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.successcondition.AnyChildStepSuccessful");
        } else if (successCondition.equals("true")) {
            successConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.successcondition.AlwaysSuccessful");
        } else if (successCondition.equals("false")) {
            successConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.successcondition.AlwaysFailed");
        } else {
            successConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.step.successcondition.ScriptSuccessCondition").addElement("script").setText(successCondition);
        }
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("environments");
    }
}

