/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.system;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Script;
import com.pmease.quickbuild.entitymanager.GroupManager;
import java.io.Serializable;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

@Editable
public class TrustUserNameInHttpHeader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String headerName;
    private String trustIps = "127.0.0.1";
    private String convertScript = "userName";
    private String defaultGroupName;

    @Editable(name="Http Header", order=100, description="Optionally specify the http header to trust user name from. If specified and the header exists, QuickBuild will take value of the header as name of an authenticated user when the remote ip address is trusted (refer to trust IPs below), and user information such as email and groups can be fetched from authenticators defined above. Normally this is used to make QuickBuild working in a single sign-on environment, with some third party software (such as Apache httpd server) actually authenticating the user and then forward the authenticated user name to QuickBuild via this header by means of reverse proxy. Refer to <a href=\"$docroot/Single+sign-on+Support\">the wiki</a> on single sign-on details.")
    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    @Editable(name="Trust IPs", order=200, description="This setting takes effect if property &quot;Http Header&quot; is specified above. Normally you should set this field to ip address of the reverse proxy server such as Apache httpd. This setting prevents untrusted remote ends from filling user in above http header and send the request to QuickBuild directly without authenticating to the front end (Apache httpd for instance) first. Multiple ip addresses should be specified by comma character.")
    @NotEmpty
    public String getTrustIps() {
        return this.trustIps;
    }

    public void setTrustIps(String trustIps) {
        this.trustIps = trustIps;
    }

    @Editable(order=250, description="If specified, this script transforms user name in specified http header to another user name before checking it against QuickBuild. In this script the preset variable <b>userName</b> represents the user name found in specified http header. For instance, you may use script <b>userName.toLowerCase()</b> to convert the user name in http header to lower case.")
    @Expressions(value={"convert to lower case", "userName.toLowerCase()", "convert to upper case", "userName.toUpperCase()"})
    @Script
    public String getConvertScript() {
        return this.convertScript;
    }

    public void setConvertScript(String convertScript) {
        this.convertScript = convertScript;
    }

    @Editable(order=300, name="Default Group", description="This setting takes effect if property &quot;Http Header&quot; is specified above. In case an authenticated user is identified via specified http header, it will be associated with the default group defined here if the user does not belong to any authenticators defined above.")
    @ChoiceProvider(value="getAllGroupNames")
    public String getDefaultGroupName() {
        return this.defaultGroupName;
    }

    public void setDefaultGroupName(String defaultGroupName) {
        this.defaultGroupName = defaultGroupName;
    }

    private static List<String> getAllGroupNames() {
        return Quickbuild.getInstance(GroupManager.class).getGroupNames();
    }
}

