/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.system;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.setting.system.PauseSystem;
import com.pmease.quickbuild.taskschedule.TaskScheduler;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.validation.ErrorContext;
import com.pmease.quickbuild.validation.Validatable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;

@Editable(description="Specify system setting here")
public class SystemSetting
implements Serializable,
Validatable {
    private static final long serialVersionUID = 1L;
    private String url;
    private String storagePath;
    private int sessionTimeout = 1800;
    private int agentTimeout = 0;
    private int autoRefreshInterval = 5;
    private boolean detectTimeZone;
    private String maintainSchedule = "0 0 0 * * ?";
    private int auditPreserveDays = 365;
    private int queuePageSize = 50;
    private boolean disableSubscriptions;
    private PauseSystem pauseSystem;
    private String customHeader;

    @Editable(order=100, name="URL to Access QuickBuild", description="Specify the root URL to access this QuickBuild server. For example: <b>http://&lt;server&gt;:8810</b>, where &lt;server&gt; represents server dns name or server ip. Please make sure this URL can be used to access this QuickBuild server from other machines in your team, and it is used when:<ul><li>QuickBuild agent communicates with QuickBuild server.</li><li>Constructs various URLs in the email build notficiations.</li></ul>")
    @NotEmpty
    @ScriptApi(value="Get Url to access QuickBuild server.")
    @Scriptable
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Editable(order=200, name="Global Storage Directory", description="Specify absolute path to the storage directory which will be used by QuickBuild to store various files generated during the build process such as published artifacts, various build reports, etc. Each project will create its own storage directory under this global directory. Please note that this global storage directory should NOT be placed under QuickBuild's installation directory.")
    @NotEmpty
    @ScriptApi(value="Get the global storage path.")
    @Scriptable
    public String getStoragePath() {
        return this.storagePath;
    }

    public void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }

    @Editable(order=400, description="Specify http session timeout in seconds. If user accessing the web UI is inactive for this period of time, QuickBuild will expire the session to save server memory. Changing this setting will affect all subsequent http sessions. Existing sessions will not be affected.")
    @Range(min=1L)
    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    @Editable(order=450, description="Specify agent timeout in seconds. If server has not hear heart beat of an active agent for this period of time, the agent will be considered inactive and removed from build grid. If 0 is specified, QuickBuild will calculate appropriate value automatically. ")
    @Min(value=0L)
    public int getAgentTimeout() {
        return this.agentTimeout;
    }

    public void setAgentTimeout(int agentTimeout) {
        this.agentTimeout = agentTimeout;
    }

    @Editable(order=500, description="Page auto-refresh interval (in seconds) is used to refresh build related pages in QuickBuild web UI automatically to display most recent information of builds. It is done in a Ajax way to save server resource. Use value <b>0</b> to disable auto refreshing.")
    @Range(min=0L)
    public int getAutoRefreshInterval() {
        return this.autoRefreshInterval;
    }

    public void setAutoRefreshInterval(int autoRefreshInterval) {
        this.autoRefreshInterval = autoRefreshInterval;
    }

    @Editable(order=550, description="Check this if you want QuickBuild to display date and accept date input in local time zone of the user accessing the web interface.<br><b>Note</b>: This setting only affects date display and input on the web page. Other dates will not be affected and still expressed in server time zone. Examples are date displayed in build notification email, date input via RESTful API, etc.")
    public boolean isDetectTimeZone() {
        return this.detectTimeZone;
    }

    public void setDetectTimeZone(boolean detectTimeZone) {
        this.detectTimeZone = detectTimeZone;
    }

    @Editable(name="System Maintenance Schedule", order=600, description="Specify schedule for system maintenance tasks such as build auto-cleanup, obsolete audit entry checking, etc. The schedule should be a cron expression with the format <b>&lt;seconds&gt; &lt;minutes&gt; &lt;hours&gt; &lt;day-of-month&gt; &lt;month&gt; &lt;day-of-week&gt;</b>. For example, <b>0 0 1 * * ?</b> means 1:00am every day. For details of the format, refer to <a href='http://www.quartz-scheduler.org/documentation/quartz-2.x/tutorials/tutorial-lesson-06'>Quartz tutorial</a>.")
    @NotEmpty
    public String getMaintainSchedule() {
        return this.maintainSchedule;
    }

    public void setMaintainSchedule(String maintainSchedule) {
        this.maintainSchedule = maintainSchedule;
    }

    @Editable(name="Audit Entry Preserve Days", order=700, description="Specify preserve days of audit entries. Entries older than these days will be deleted.")
    public int getAuditPreserveDays() {
        return this.auditPreserveDays;
    }

    public void setAuditPreserveDays(int auditPreserveDays) {
        this.auditPreserveDays = auditPreserveDays;
    }

    @Editable(order=750, description="How many entries to display in one page of the build queue.")
    public int getQueuePageSize() {
        return this.queuePageSize;
    }

    public void setQueuePageSize(int queuePageSize) {
        this.queuePageSize = queuePageSize;
    }

    @Editable(order=760, description="Disable the ability to subscribe to build notifications per user. This might be useful if you would like to manage all build notifications centrally via configuration notification settings.")
    public boolean isDisableSubscriptions() {
        return this.disableSubscriptions;
    }

    public void setDisableSubscriptions(boolean disableSubscriptions) {
        this.disableSubscriptions = disableSubscriptions;
    }

    @Editable(name="Pause System?", order=800, description="Check this to pause the system to prevent new builds from running (already running builds will not be affected).")
    public PauseSystem getPauseSystem() {
        return this.pauseSystem;
    }

    public void setPauseSystem(PauseSystem pauseSystem) {
        this.pauseSystem = pauseSystem;
    }

    @Editable(name="Custom Header", order=900, description="Optionally specify a html snippet to customize header of QuickBuild pages. For instance: below html snippet displays a blue banner with text <i>My QuickBuild Instance</i>:<br>&lt;h2 style=&quot;background-color:blue; padding:8px; color:white; margin-bottom:-8px;&quot;&gt;My QuickBuild Instance&lt;/h2&gt;")
    @Multiline
    public String getCustomHeader() {
        return this.customHeader;
    }

    public void setCustomHeader(String customHeader) {
        this.customHeader = customHeader;
    }

    @Override
    public void validate(Set<String> properties, ErrorContext errorContext) {
        if (properties.contains("maintainSchedule")) {
            errorContext.setError("maintainSchedule", TaskScheduler.instance.checkCronExpression(this.getMaintainSchedule()));
        }
        if (properties.contains("url") && !this.getUrl().startsWith("http://") && !this.getUrl().startsWith("https://")) {
            errorContext.setError("url", "URL should either starts with \"http://\" or starts with \"https://\".");
        }
        if (properties.contains("storagePath")) {
            if (!new File(this.getStoragePath()).isAbsolute()) {
                errorContext.setError("storagePath", "Please specify an absolute path to the storage directory.");
            } else {
                try {
                    if (FileUtils.getRelativePath(new File(this.getStoragePath()).getCanonicalPath(), Bootstrap.installDir.getCanonicalPath()) != null) {
                        errorContext.setError("storagePath", "Storage directory should not be identical to or placed under QuickBuild install directory.");
                    }
                }
                catch (IOException e) {
                    errorContext.setError("storagePath", "Invalid storage path: " + e.getMessage());
                }
            }
        }
    }
}

