/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.system;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.entitymanager.GroupManager;
import com.pmease.quickbuild.migration.MigrationListener;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.security.Authenticator;
import com.pmease.quickbuild.security.FailSafeAuthenticator;
import com.pmease.quickbuild.setting.system.TrustUserNameInHttpHeader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecuritySetting
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SecuritySetting.class);
    private List<VersionedDocument> authenticatorDOMs = new ArrayList<VersionedDocument>();
    private TrustUserNameInHttpHeader trustUserNameInHttpHeader = new TrustUserNameInHttpHeader();

    public List<VersionedDocument> getAuthenticatorDOMs() {
        return this.authenticatorDOMs;
    }

    public void setAuthenticatorDOMs(List<VersionedDocument> authenticatorDOMs) {
        this.authenticatorDOMs = authenticatorDOMs;
    }

    public TrustUserNameInHttpHeader getTrustUserNameInHttpHeader() {
        return this.trustUserNameInHttpHeader;
    }

    public void setTrustUserNameInHttpHeader(TrustUserNameInHttpHeader trustUserNameInHttpHeader) {
        this.trustUserNameInHttpHeader = trustUserNameInHttpHeader;
    }

    private static List<String> getAllGroupNames() {
        return Quickbuild.getInstance(GroupManager.class).getGroupNames();
    }

    public List<Authenticator> getAuthenticators(boolean installInterpolator) {
        ArrayList<Authenticator> authenticators = new ArrayList<Authenticator>();
        for (VersionedDocument dom : this.getAuthenticatorDOMs()) {
            Authenticator authenticator;
            try {
                authenticator = (Authenticator)dom.toBean(new MigrationListener(){

                    @Override
                    public void afterMigration(Object bean) {
                    }
                });
            }
            catch (Exception e) {
                logger.error("Error constructing authenticator from DOM.", (Throwable)e);
                authenticator = new FailSafeAuthenticator();
                authenticator.setDescription(e.getClass().getSimpleName() + ":" + e.getMessage());
                authenticator.setName(dom.getValue("name"));
                authenticators.add(authenticator);
            }
            if (installInterpolator) {
                authenticator = (Authenticator)Quickbuild.getInstance(ScriptEngine.class).installInterpolator(authenticator);
            }
            authenticators.add(authenticator);
        }
        return authenticators;
    }
}

