/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.system;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import java.io.Serializable;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(description="Specify email setting here. This setting will be used by QuickBuild to send out emails such as build notifications, password recovery emails, etc.")
public class EmailSetting
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String smtpHost;
    private int smtpPort = 25;
    private int sslSmtpPort = 465;
    private boolean smtpOverSSL;
    private String smtpUser;
    private String smtpPassword;
    private boolean enableStartTLS;
    private String senderAddress;
    private String replyAddress;
    private int timeout = 300;

    @Editable(order=100, name="SMTP Host", description="Specify the SMTP mail host used by QuickBuild to send email")
    @NotEmpty
    @ScriptApi
    @Scriptable
    public String getSmtpHost() {
        return this.smtpHost;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    @Editable(order=200, name="SMTP Port", description="Specify port number for the above SMTP host. This port number will be used if the option 'Use SMTP over SSL' is not checked.")
    @ScriptApi
    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    @Editable(order=210, name="SSL SMTP Port", description="Specify SSL port number for the above SMTP host. This port number will be used if the option 'Use SMTP over SSL' is checked.")
    @ScriptApi
    public int getSslSmtpPort() {
        return this.sslSmtpPort;
    }

    public void setSslSmtpPort(int sslSmtpPort) {
        this.sslSmtpPort = sslSmtpPort;
    }

    @Editable(order=250, name="Use SMTP over SSL?", description="Whether or not send email using SMTP over SSL. If SSL is enabled, and a <b>SSLHandshakeException</b> is thrown with message <b>unable to find valid certification path to requested target</b> while sending the email, please make sure public key of your SMTP server is trusted by QuickBuild.")
    public boolean isSmtpOverSSL() {
        return this.smtpOverSSL;
    }

    public void setSmtpOverSSL(boolean smtpOverSSL) {
        this.smtpOverSSL = smtpOverSSL;
    }

    @Editable(order=300, name="SMTP User", description="Optionally specify user name here if the SMTP host needs authentication")
    @ScriptApi
    @Scriptable
    public String getSmtpUser() {
        return this.smtpUser;
    }

    public void setSmtpUser(String smtpUser) {
        this.smtpUser = smtpUser;
    }

    @Editable(order=400, name="SMTP Password", description="Optionally specify password here if the SMTP host needs authentication")
    @ScriptApi
    @Password
    @Scriptable
    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = smtpPassword;
    }

    @Editable(order=450, name="Enable Start TLS?", description="Whether the STARTTLS command used to switch to an encrypted connection for authentication.")
    @ScriptApi
    public boolean isEnableStartTLS() {
        return this.enableStartTLS;
    }

    public void setEnableStartTLS(boolean enableStartTLS) {
        this.enableStartTLS = enableStartTLS;
    }

    @Editable(order=500, description="This property is optional. If specified, QuickBuild will use this email as the sender address when sending out emails. Otherwise, the sender address will be <b>quickbuild@&lt;hostname&gt;</b>, where &lt;hostname&gt; is the host name of the build machine.")
    @ScriptApi
    @Scriptable
    public String getSenderAddress() {
        return this.senderAddress;
    }

    public void setSenderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
    }

    @Editable(order=500, description="This property is optional. If specified, QuickBuild will use this email as the reply-to address when user replies to the notification email. Otherwise, the sender address will be used.")
    @ScriptApi
    @Scriptable
    public String getReplyAddress() {
        return this.replyAddress;
    }

    public void setReplyAddress(String replyAddress) {
        this.replyAddress = replyAddress;
    }

    @Editable(order=600, description="Specify timeout in seconds when communicating with the SMTP server. Use 0 to set an infinite timeout.")
    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

