/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.system;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.taskschedule.TaskScheduler;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.validation.ErrorContext;
import com.pmease.quickbuild.validation.Validatable;
import java.io.File;
import java.io.Serializable;
import java.util.Set;
import java.util.UUID;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoBackupSetting
implements Serializable,
Validatable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AutoBackupSetting.class);
    private String schedule;
    private String folder;
    private String filePattern = "yyyy.MM.dd_HH.mm.ss";
    private boolean excludeBuilds;
    private boolean excludeMeasurements;
    private boolean excludeAudits;

    @Editable(order=100, name="Backup Schedule", description="Optionally specify a cron expression to schedule database auto-backup. The cron expression format is <em>&lt;seconds&gt; &lt;minutes&gt; &lt;hours&gt; &lt;day-of-month&gt; &lt;month&gt; &lt;day-of-week&gt;</em>.For example, <em>0 0 1 * * ?</em> means 1:00am every day. For details of the format, refer to <a href='http://www.quartz-scheduler.org/documentation/quartz-2.x/tutorials/tutorial-lesson-06'>Quartz tutorial</a>.The backup files will be placed into <em>backup</em> folder under QuickBuild's installation directory. Leave this property empty if you do not want to enable database auto backup.")
    @NotEmpty
    @Scriptable
    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    @Editable(order=200, name="Backup Directory", description="Specify the directory to which the auto backup files will be stored. Non-absolute path will be considered to be relative to installation directory of QuickBuild server.")
    @NotEmpty
    @Scriptable
    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    @Editable(name="Backup File Pattern", order=250, description="Specify <a href=\"http://docs.oracle.com/javase/1.5.0/docs/api/java/text/SimpleDateFormat.html\">date pattern</a> of the auto backup file name. You don't need to specify suffix of the file since QuickBuild will append the suffix \".zip\" to the file name automatically.")
    @NotEmpty
    @Scriptable
    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    @Editable(order=300, description="If checked, builds will be excluded from the backup. For a large deployment, excluding builds from backup can speed backup process dramatically.")
    public boolean isExcludeBuilds() {
        return this.excludeBuilds;
    }

    public void setExcludeBuilds(boolean excludeBuilds) {
        this.excludeBuilds = excludeBuilds;
    }

    @Editable(order=400, description="If checked, measurement data will be excluded from the backup. For a large deployment, excluding measurement data from backup can speed backup process dramatically.")
    public boolean isExcludeMeasurements() {
        return this.excludeMeasurements;
    }

    public void setExcludeMeasurements(boolean excludeMeasurements) {
        this.excludeMeasurements = excludeMeasurements;
    }

    @Editable(order=500, description="If checked, audit data will be excluded from the backup. For a large deployment, excluding audit data from backup can speed backup process dramatically.")
    public boolean isExcludeAudits() {
        return this.excludeAudits;
    }

    public void setExcludeAudits(boolean excludeAudits) {
        this.excludeAudits = excludeAudits;
    }

    @Override
    public void validate(Set<String> properties, ErrorContext errorContext) {
        ScriptEngine scriptEngine = Quickbuild.getInstance(ScriptEngine.class);
        if (properties.contains("schedule") && !scriptEngine.interpolative(this.getSchedule())) {
            TaskScheduler scheduler = Quickbuild.getInstance(TaskScheduler.class);
            errorContext.setError("schedule", scheduler.checkCronExpression(this.getSchedule()));
        }
        if (properties.contains("folder") && !scriptEngine.interpolative(this.getFolder())) {
            File folder = new File(this.getFolder());
            if (!folder.isAbsolute()) {
                folder = new File(Bootstrap.installDir, this.getFolder());
            }
            if (!folder.exists()) {
                errorContext.setError("folder", "Backup directory does not exist.");
            } else {
                File tempFile = new File(folder, UUID.randomUUID().toString());
                try {
                    FileUtils.createFile(tempFile);
                    FileUtils.deleteFile(tempFile);
                }
                catch (Exception e) {
                    logger.error("Error testing backup directory.", (Throwable)e);
                    errorContext.setError("folder", "Unable to create test file under backup directory. Please make sure the user running QuickBuild process has write permission to the backup directory.");
                }
            }
        }
    }
}

