/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.successcondition;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.setting.step.successcondition.SuccessCondition;
import com.pmease.quickbuild.setting.step.successcondition.SuccessConditionCriteria;
import com.pmease.quickbuild.stepsupport.CompositeStep;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="If one of specified criterias is satisfied", order=90)
public class OrSuccessCondition
implements SuccessCondition {
    private static final long serialVersionUID = 1L;
    private List<SuccessConditionCriteria> criterias;

    @Editable
    @Size(min=2, max=100)
    public List<SuccessConditionCriteria> getCriterias() {
        return this.criterias;
    }

    public void setCriterias(List<SuccessConditionCriteria> criterias) {
        this.criterias = criterias;
    }

    @Override
    public boolean satisfied(CompositeStep step) {
        for (SuccessConditionCriteria each : this.getCriterias()) {
            if (!each.getCriteria().satisfied(step)) continue;
            return true;
        }
        return false;
    }
}

