/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.repetition.nodefilter;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Current;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Script;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.setting.step.repetition.nodefilter.NodeFilter;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.EasyMap;
import java.util.Map;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Node with specified script evaluating to true", order=200)
@Current(value=Step.class)
public class ScriptNodeFilter
implements NodeFilter {
    private static final long serialVersionUID = 1L;
    private String script;

    @Editable(description="Specify the script to evaulate. The node to be matched is available as <b>node</b> object in the script context.")
    @Script
    @Scriptable
    @NotEmpty
    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public boolean matches(Step step, GridNode node) {
        ScriptEngine scriptEngine = Quickbuild.getInstance(ScriptEngine.class);
        Map<String, Object> evalContext = Context.buildEvalContext(step, EasyMap.create("node", node));
        return (Boolean)scriptEngine.evaluate(this.getScript(), evalContext);
    }
}

