/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.repetition.nodefilter;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.annotation.Current;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.entitymanager.ResourceManager;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Resource;
import com.pmease.quickbuild.setting.step.repetition.nodefilter.NodeFilter;
import com.pmease.quickbuild.stepsupport.Step;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Node with specified resource defined", order=195)
@Current(value=Step.class)
public class ResourceNodeFilter
implements NodeFilter {
    private static final long serialVersionUID = 1L;
    private String resource;

    @Editable(name="Resource")
    @NotEmpty
    @Scriptable
    @ExpressionProvider(value="getResourceChoices")
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    private static Map<String, String> getResourceChoices() {
        LinkedHashMap<String, String> choices = new LinkedHashMap<String, String>();
        List<Resource> resources = CacheManager.instance.getResources();
        Collections.sort(resources, new Comparator<Resource>(){

            @Override
            public int compare(Resource r1, Resource r2) {
                return r1.getName().compareTo(r2.getName());
            }
        });
        for (Resource resource : resources) {
            choices.put(resource.getName(), resource.getName());
        }
        return choices;
    }

    @Override
    public boolean matches(Step step, GridNode node) {
        Resource resource = ResourceManager.instance.get(this.getResource());
        return resource.getCount(node) > 0;
    }
}

