/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.repetition;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.setting.step.repetition.ParamValues;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.validation.ErrorContext;
import com.pmease.quickbuild.validation.Validatable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Comma or new line separated values", order=10)
public class SpecifiedValues
implements ParamValues,
Validatable {
    private static final long serialVersionUID = 1L;
    private String values;

    @Editable(description="Specify repeating params here. Different params need to be separated by comma or new line. Please note that character '>?&=#' can not be used here.")
    @NotEmpty
    @Scriptable
    public String getValues() {
        return this.values;
    }

    public void setValues(String values) {
        this.values = values;
    }

    @Override
    public List<String> get(Step step) {
        if (this.getValues() != null) {
            return StringUtils.splitAndTrim(this.getValues());
        }
        return new ArrayList<String>();
    }

    @Override
    public void validate(Set<String> properties, ErrorContext errorContext) {
        if (properties.contains("values") && StringUtils.containsAny((String)this.getValues(), (String)">?&=#")) {
            errorContext.setError("values", "Character \">?&=#\" can not be contained in parameter values.");
        }
    }
}

