/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.repetition;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.setting.step.repetition.ParamValues;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Files and directories matching specified patterns", order=50)
public class MatchedFiles
implements ParamValues {
    private static final long serialVersionUID = 1L;
    private String srcPath;
    private String patterns;
    private boolean includeDir = false;
    private boolean includeFile = true;
    private boolean useRelativePath = false;

    @Editable(order=1000, name="Source Directory", description="Specify the directory under which to match files. A non-absolute path is considered to be relative to current workspace directory . If left empty, the workspace directory itself will be used.")
    @Scriptable
    public String getSrcPath() {
        return this.srcPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    @Editable(order=1100, name="Files To Match", description="Specify patterns of files to be matched. Patterns will be matched under the <b>source directory</b> specified above.<br><strong>NOTE:</strong> refer to <a href=\"$docroot/File+Pattern+Reference\" target=\"_blank\">the file patterns reference</a> for details of the file patterns.")
    @Expressions(value={"all files (recursively)", "**", "all files (non-recursively)", "*"})
    @NotEmpty
    public String getPatterns() {
        return this.patterns;
    }

    public void setPatterns(String patterns) {
        this.patterns = patterns;
    }

    @Editable(name="Include Directories?", order=1200, description="Whether or not to include matched directories.")
    public boolean isIncludeDir() {
        return this.includeDir;
    }

    public void setIncludeDir(boolean includeDir) {
        this.includeDir = includeDir;
    }

    @Editable(name="Include Files?", order=1200, description="Whether or not to include matched files.")
    public boolean isIncludeFile() {
        return this.includeFile;
    }

    public void setIncludeFile(boolean includeFile) {
        this.includeFile = includeFile;
    }

    @Editable(order=1300, description="Whether or not to use relative path of matched files and directories.")
    public boolean isUseRelativePath() {
        return this.useRelativePath;
    }

    public void setUseRelativePath(boolean useRelativePath) {
        this.useRelativePath = useRelativePath;
    }

    @Override
    public List<String> get(Step step) {
        ArrayList<String> values = new ArrayList<String>();
        File srcDir = FileUtils.resolvePath(Context.getConfiguration().getWorkspaceDir(), this.getSrcPath());
        for (File each : FileUtils.listFiles(srcDir, this.getPatterns())) {
            if ((!each.isDirectory() || !this.isIncludeDir()) && (!each.isFile() || !this.isIncludeFile())) continue;
            if (this.isUseRelativePath()) {
                String relative = FileUtils.getRelativePath(each.getAbsolutePath(), srcDir.getAbsolutePath());
                relative = StringUtils.stripStart((String)relative, (String)"/");
                relative = StringUtils.replace((String)relative, (String)"/", (String)File.separator);
                values.add(relative);
                continue;
            }
            values.add(each.getAbsolutePath());
        }
        return values;
    }
}

