/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.repetition;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.setting.step.repetition.ParamValues;
import com.pmease.quickbuild.setting.step.repetition.nodefilter.NodeFilter;
import com.pmease.quickbuild.stepsupport.Step;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;

@Editable(name="Addresses of all nodes filtered by specified criteria", order=20)
public class FilteredNodes
implements ParamValues {
    private static final long serialVersionUID = 1L;
    private NodeFilter nodeFilter;

    @Editable(name="Criteria", order=100, description="Specify the criteria to filter nodes.")
    @NotNull
    public NodeFilter getNodeFilter() {
        return this.nodeFilter;
    }

    public void setNodeFilter(NodeFilter nodeFilter) {
        this.nodeFilter = nodeFilter;
    }

    @Override
    public List<String> get(Step step) {
        ArrayList<String> values = new ArrayList<String>();
        for (GridNode each : Grid.instance.getAllNodes()) {
            if (!this.getNodeFilter().matches(step, each)) continue;
            values.add(each.getAddress());
        }
        return values;
    }
}

