/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.nodepreference;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Script;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.setting.step.nodepreference.NodePreference;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.EasyMap;
import java.util.Collection;
import java.util.Map;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Select preferred node using a script", order=900)
public class ScriptLoadPredictor
implements NodePreference {
    private static final long serialVersionUID = 1L;
    private String script;

    @Editable(description="Specify the script to evaluate to get the node running the step. The script context contains an object <b>nodes</b>, representing the collection of nodes matching criterias specified above, and the script is expected to return a node object in this collection. Please note that this script will always be executed on server although node object can be different than server.")
    @Script
    @Scriptable
    @NotEmpty
    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public GridNode getPreference(Collection<GridNode> nodes, Step step) {
        Map<String, Object> evalContext = Context.buildEvalContext(step, EasyMap.create("nodes", nodes));
        return (GridNode)ScriptEngine.instance.evaluate(this.getScript(), evalContext);
    }
}

